/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionArbiter;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;

final class MultiConcatArray<T>
implements Multi<T> {
    private final Flow.Publisher<T>[] sources;

    MultiConcatArray(Flow.Publisher<T>[] sources) {
        this.sources = sources;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(subscriber, this.sources);
        subscriber.onSubscribe(parent);
        parent.nextSource();
    }

    static final class ConcatArraySubscriber<T>
    extends SubscriptionArbiter
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super T> downstream;
        private final Flow.Publisher<T>[] sources;
        private final AtomicInteger wip;
        private int index;
        private long produced;

        ConcatArraySubscriber(Flow.Subscriber<? super T> downstream, Flow.Publisher<T>[] sources) {
            this.downstream = downstream;
            this.sources = sources;
            this.wip = new AtomicInteger();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            super.setSubscription(subscription);
        }

        @Override
        public void onNext(T item) {
            ++this.produced;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            long produced = this.produced;
            if (produced != 0L) {
                this.produced = 0L;
                super.produced(produced);
            }
            this.nextSource();
        }

        public void nextSource() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.index == this.sources.length) {
                        this.downstream.onComplete();
                        continue;
                    }
                    this.sources[this.index++].subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
            } else {
                super.request(n);
            }
        }
    }
}

