/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Awaitable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class CompletionAwaitable<T>
implements CompletionStage<T>,
Awaitable<T> {
    private Supplier<CompletionStage<T>> originalStage;

    CompletionAwaitable(Supplier<CompletionStage<T>> originalStage, CompletionAwaitable<?> parent) {
        this.originalStage = originalStage;
    }

    CompletionAwaitable() {
    }

    void setOriginalStage(Supplier<CompletionStage<T>> originalStage) {
        this.originalStage = originalStage;
    }

    @Override
    public <U> CompletionAwaitable<U> thenApply(Function<? super T, ? extends U> fn) {
        CompletionStage completionStage = this.originalStage.get().thenApply(fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        CompletionStage completionStage = this.originalStage.get().thenApplyAsync(fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        CompletionStage completionStage = this.originalStage.get().thenApplyAsync(fn, executor);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> thenAccept(Consumer<? super T> action) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenAccept(action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> thenAcceptAsync(Consumer<? super T> action) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenAcceptAsync(action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenAcceptAsync(action, executor);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> thenRun(Runnable action) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenRun(action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> thenRunAsync(Runnable action) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenRunAsync(action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> thenRunAsync(Runnable action, Executor executor) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenRunAsync(action, executor);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    @Override
    public <U, V> CompletionAwaitable<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        CompletionStage completionStage = this.originalStage.get().thenCombine(other, fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U, V> CompletionAwaitable<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        CompletionStage completionStage = this.originalStage.get().thenCombineAsync(other, fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U, V> CompletionAwaitable<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        CompletionStage completionStage = this.originalStage.get().thenCombineAsync(other, fn, executor);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    public <U> CompletionAwaitable<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenAcceptBoth(other, action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public <U> CompletionAwaitable<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenAcceptBothAsync(other, action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public <U> CompletionAwaitable<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        CompletionStage<Void> completionStage = this.originalStage.get().thenAcceptBothAsync(other, action, executor);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        CompletionStage<Void> completionStage = this.originalStage.get().runAfterBoth(other, action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        CompletionStage<Void> completionStage = this.originalStage.get().runAfterBothAsync(other, action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        CompletionStage<Void> completionStage = this.originalStage.get().runAfterBothAsync(other, action, executor);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        CompletionStage completionStage = this.originalStage.get().applyToEither(other, fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        CompletionStage completionStage = this.originalStage.get().applyToEitherAsync(other, fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        CompletionStage completionStage = this.originalStage.get().applyToEitherAsync(other, fn, executor);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        CompletionStage<Void> completionStage = this.originalStage.get().acceptEither(other, action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        CompletionStage<Void> completionStage = this.originalStage.get().acceptEitherAsync(other, action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        CompletionStage<Void> completionStage = this.originalStage.get().acceptEitherAsync(other, action, executor);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        CompletionStage<Void> completionStage = this.originalStage.get().runAfterEither(other, action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        CompletionStage<Void> completionStage = this.originalStage.get().runAfterEitherAsync(other, action);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    public CompletionAwaitable<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        CompletionStage<Void> completionStage = this.originalStage.get().runAfterEitherAsync(other, action, executor);
        return new CompletionAwaitable<Void>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        CompletionStage completionStage = this.originalStage.get().thenCompose(fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        CompletionStage completionStage = this.originalStage.get().thenComposeAsync(fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        CompletionStage completionStage = this.originalStage.get().thenComposeAsync(fn, executor);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        CompletionStage completionStage = this.originalStage.get().handle(fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        CompletionStage completionStage = this.originalStage.get().handleAsync(fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public <U> CompletionAwaitable<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        CompletionStage completionStage = this.originalStage.get().handleAsync(fn, executor);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public CompletionAwaitable<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        CompletionStage completionStage = this.originalStage.get().whenComplete(action);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public CompletionAwaitable<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        CompletionStage completionStage = this.originalStage.get().whenCompleteAsync(action);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public CompletionAwaitable<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        CompletionStage completionStage = this.originalStage.get().whenCompleteAsync(action, executor);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public CompletionAwaitable<T> exceptionally(Function<Throwable, ? extends T> fn) {
        CompletionStage completionStage = this.originalStage.get().exceptionally(fn);
        return new CompletionAwaitable<T>(() -> completionStage, this);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.originalStage.get().toCompletableFuture();
    }
}

