/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.Optional;
import java.util.concurrent.Flow;

class SubscriberReference<T>
implements Flow.Subscriber<T> {
    private Optional<Flow.Subscriber<T>> subscriber;

    private SubscriberReference(Flow.Subscriber<T> subscriber) {
        this.subscriber = Optional.of(subscriber);
    }

    static <T> SubscriberReference<T> create(Flow.Subscriber<T> subscriber) {
        return new SubscriberReference<T>(subscriber);
    }

    void releaseReference() {
        this.subscriber = Optional.empty();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscriber.ifPresent(s -> s.onSubscribe(subscription));
    }

    @Override
    public void onNext(T item) {
        this.subscriber.ifPresent(s -> s.onNext(item));
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscriber.ifPresent(s -> s.onError(throwable));
    }

    @Override
    public void onComplete() {
        this.subscriber.ifPresent(Flow.Subscriber::onComplete);
    }
}

