/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.FunctionalSubscriber;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiOnErrorResumeProcessor;
import io.helidon.common.reactive.MultiTappedProcessor;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Subscribable<T>
extends Flow.Publisher<T> {
    @Override
    default public void subscribe(Consumer<? super T> consumer) {
        this.subscribe(new FunctionalSubscriber<T>(consumer, null, null, null));
    }

    default public void subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer) {
        this.subscribe(new FunctionalSubscriber<T>(consumer, errorConsumer, null, null));
    }

    default public void subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer) {
        this.subscribe(new FunctionalSubscriber<T>(consumer, errorConsumer, completeConsumer, null));
    }

    default public void subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, Consumer<? super Flow.Subscription> subscriptionConsumer) {
        this.subscribe(new FunctionalSubscriber<T>(consumer, errorConsumer, completeConsumer, subscriptionConsumer));
    }

    default public Multi<T> onTerminate(Runnable onTerminate) {
        Multi processor = ((MultiTappedProcessor)MultiTappedProcessor.create().onComplete(onTerminate)).onCancel(s -> onTerminate.run()).onError(t -> onTerminate.run());
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> onComplete(Runnable onTerminate) {
        Multi processor = MultiTappedProcessor.create().onComplete(onTerminate);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> onError(Consumer<Throwable> onErrorConsumer) {
        Multi processor = MultiTappedProcessor.create().onError((Consumer)onErrorConsumer);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> onErrorResume(Function<Throwable, T> onError) {
        MultiOnErrorResumeProcessor processor = MultiOnErrorResumeProcessor.resume(onError);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> onErrorResumeWith(Function<Throwable, Flow.Publisher<T>> onError) {
        MultiOnErrorResumeProcessor<T> processor = MultiOnErrorResumeProcessor.resumeWith(onError);
        this.subscribe(processor);
        return processor;
    }
}

