/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class StreamValidationUtils {
    private StreamValidationUtils() {
    }

    public static <T> boolean checkRecursionDepth(int maxDepth, BiConsumer<Long, Throwable> onExceeded) {
        Long recursionDepth = StreamValidationUtils.getRecursionDepth();
        if (recursionDepth > (long)maxDepth) {
            Optional.of(onExceeded).ifPresent(onExc -> onExc.accept(recursionDepth, new IllegalCallerException(String.format("Recursion depth exceeded, max depth expected %d but actual is %d, rule 3.3", maxDepth, recursionDepth))));
            return false;
        }
        return true;
    }

    public static boolean checkRequestParam(long requestParam, Consumer<? super IllegalArgumentException> onExceeded) {
        if (requestParam <= 0L) {
            Optional.of(onExceeded).ifPresent(onExc -> onExc.accept(new IllegalArgumentException(String.format("Non-positive subscription request %d, rule 3.9", requestParam))));
            return false;
        }
        return true;
    }

    static Long getRecursionDepth() {
        StackTraceElement parentElement = ((StackWalker.StackFrame)StackWalker.getInstance().walk(stackFrameStream -> stackFrameStream.skip(1L).findFirst()).get()).toStackTraceElement();
        return StackWalker.getInstance().walk(ss -> ss.map(StackWalker.StackFrame::toStackTraceElement).filter(el -> StreamValidationUtils.stackTraceElementEquals(el, parentElement)).count());
    }

    static boolean stackTraceElementEquals(StackTraceElement a, StackTraceElement b) {
        return Objects.equals(a.getClassLoaderName(), b.getClassLoaderName()) && Objects.equals(a.getModuleName(), b.getModuleName()) && Objects.equals(a.getModuleVersion(), b.getModuleVersion()) && Objects.equals(a.getClassName(), b.getClassName()) && Objects.equals(a.getMethodName(), b.getMethodName());
    }
}

