/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;

final class SingleSubscription<T>
implements Flow.Subscription {
    private final T value;
    private final Flow.Subscriber<? super T> subscriber;
    private final AtomicBoolean delivered;
    private final AtomicBoolean canceled;

    SingleSubscription(T value, Flow.Subscriber<? super T> subscriber) {
        this.value = value;
        this.subscriber = subscriber;
        this.delivered = new AtomicBoolean(false);
        this.canceled = new AtomicBoolean(false);
    }

    @Override
    public void request(long n) {
        if (n >= 0L && !this.canceled.get() && this.delivered.compareAndSet(false, true)) {
            this.subscriber.onNext(this.value);
            this.subscriber.onComplete();
        }
    }

    @Override
    public void cancel() {
        this.canceled.set(true);
    }
}

