/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.StreamValidationUtils;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class RequestedCounter {
    private final AtomicLong requested = new AtomicLong();

    public void increment(long increment, Consumer<? super IllegalArgumentException> errorHandler) {
        if (!StreamValidationUtils.checkRequestParam(increment, errorHandler)) {
            return;
        }
        this.requested.updateAndGet(original -> {
            if (original == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            long r = original + increment;
            if (r == Long.MAX_VALUE || ((original ^ r) & (increment ^ r)) < 0L) {
                return Long.MAX_VALUE;
            }
            return r;
        });
    }

    public boolean tryDecrement() {
        return this.requested.getAndUpdate(val -> {
            if (val == Long.MAX_VALUE) {
                return val;
            }
            if (val > 0L) {
                return val - 1L;
            }
            return 0L;
        }) > 0L;
    }

    public long get() {
        return this.requested.get();
    }
}

