/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BufferedProcessor;
import io.helidon.common.reactive.Multi;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;

public class MultiTappedProcessor<R>
extends BufferedProcessor<R, R>
implements Multi<R> {
    private Optional<Function<R, R>> onNextFunction = Optional.empty();
    private Optional<Consumer<Throwable>> onErrorConsumer = Optional.empty();
    private Optional<Runnable> onCompleteRunnable = Optional.empty();
    private Optional<Consumer<Flow.Subscription>> onCancelConsumer = Optional.empty();

    private MultiTappedProcessor() {
    }

    public static <R> MultiTappedProcessor<R> create() {
        return new MultiTappedProcessor<R>();
    }

    public MultiTappedProcessor<R> onNext(Function<R, R> function) {
        this.onNextFunction = Optional.ofNullable(function);
        return this;
    }

    @Override
    public MultiTappedProcessor<R> onError(Consumer<Throwable> consumer) {
        this.onErrorConsumer = Optional.ofNullable(consumer);
        return this;
    }

    @Override
    public MultiTappedProcessor<R> onComplete(Runnable runnable) {
        this.onCompleteRunnable = Optional.ofNullable(runnable);
        return this;
    }

    public MultiTappedProcessor<R> onCancel(Consumer<Flow.Subscription> consumer) {
        this.onCancelConsumer = Optional.ofNullable(consumer);
        return this;
    }

    @Override
    protected void hookOnNext(R item) {
        this.submit(this.onNextFunction.map((? super T f) -> f.apply(item)).orElse(item));
    }

    @Override
    protected void hookOnError(Throwable error) {
        this.onErrorConsumer.ifPresent(c -> c.accept(error));
        super.hookOnError(error);
    }

    @Override
    protected void hookOnComplete() {
        this.onCompleteRunnable.ifPresent(Runnable::run);
        super.hookOnComplete();
    }

    @Override
    protected void hookOnCancel(Flow.Subscription subscription) {
        this.onCancelConsumer.ifPresent(c -> c.accept(subscription));
        subscription.cancel();
    }
}

