/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BufferedProcessor;
import io.helidon.common.reactive.Multi;
import java.util.concurrent.Flow;
import java.util.function.Predicate;

public class MultiTakeWhileProcessor<T>
extends BufferedProcessor<T, T>
implements Multi<T> {
    private Predicate<T> predicate;

    private MultiTakeWhileProcessor(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public static <T> MultiTakeWhileProcessor<T> create(Predicate<T> predicate) {
        return new MultiTakeWhileProcessor<T>(predicate);
    }

    @Override
    protected void hookOnNext(T item) {
        if (this.predicate.test(item)) {
            this.submit(item);
        } else {
            this.getSubscription().ifPresent(Flow.Subscription::cancel);
            this.tryComplete();
        }
    }
}

