/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BufferedProcessor;
import io.helidon.common.reactive.Multi;
import java.util.concurrent.atomic.AtomicLong;

public class MultiSkipProcessor<T>
extends BufferedProcessor<T, T>
implements Multi<T> {
    private final AtomicLong counter;

    private MultiSkipProcessor(Long skip) {
        this.counter = new AtomicLong(skip);
    }

    public static <T> MultiSkipProcessor<T> create(Long skip) {
        return new MultiSkipProcessor<T>(skip);
    }

    @Override
    protected void hookOnNext(T item) {
        long actCounter = this.counter.getAndDecrement();
        if (0L >= actCounter) {
            this.submit(item);
        } else {
            this.getRequestedCounter().tryDecrement();
            this.request(1L);
        }
    }
}

