/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BufferedProcessor;
import io.helidon.common.reactive.Multi;
import java.util.function.Consumer;

public class MultiPeekProcessor<T>
extends BufferedProcessor<T, T>
implements Multi<T> {
    private Consumer<T> consumer;

    private MultiPeekProcessor(Consumer<T> consumer) {
        this.consumer = consumer;
    }

    public static <T> MultiPeekProcessor<T> create(Consumer<T> consumer) {
        return new MultiPeekProcessor<T>(consumer);
    }

    @Override
    protected void hookOnNext(T item) {
        this.consumer.accept(item);
        this.submit(item);
    }

    public String toString() {
        return "PeekProcessor{consumer=" + this.consumer + "}";
    }
}

