/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.BufferedProcessor;
import io.helidon.common.reactive.Multi;
import java.util.Objects;
import java.util.concurrent.Flow;

public final class MultiMapProcessor<T, U>
extends BufferedProcessor<T, U>
implements Multi<U> {
    private final Mapper<T, U> mapper;

    private MultiMapProcessor(Mapper<T, U> mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null!");
    }

    public static <T, U> MultiMapProcessor<T, U> create(Mapper<T, U> mapper) {
        return new MultiMapProcessor<T, U>(mapper);
    }

    @Override
    protected void hookOnCancel(Flow.Subscription subscription) {
        subscription.cancel();
    }

    @Override
    protected void hookOnNext(T item) {
        Object value = this.mapper.map(item);
        if (value == null) {
            this.getSubscription().ifPresent(Flow.Subscription::cancel);
            this.onError(new NullPointerException("Mapper returned a null value"));
        } else {
            this.submit(value);
        }
    }
}

