/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BaseProcessor;
import io.helidon.common.reactive.Single;
import java.util.concurrent.atomic.AtomicBoolean;

final class MultiFirstProcessor<T>
extends BaseProcessor<T, T>
implements Single<T> {
    private AtomicBoolean nextCalled = new AtomicBoolean(false);

    private MultiFirstProcessor() {
    }

    static <T> MultiFirstProcessor<T> create() {
        return new MultiFirstProcessor<T>();
    }

    @Override
    public void onNext(T item) {
        if (!this.nextCalled.getAndSet(true)) {
            super.onNext(item);
        }
    }

    @Override
    protected void hookOnNext(T item) {
        this.submit(item);
        this.onComplete();
    }
}

