/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BufferedProcessor;
import io.helidon.common.reactive.Multi;
import java.util.function.Predicate;

public class MultiFilterProcessor<T>
extends BufferedProcessor<T, T>
implements Multi<T> {
    private Predicate<T> predicate;

    private MultiFilterProcessor(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public static <T> MultiFilterProcessor<T> create(Predicate<T> predicate) {
        return new MultiFilterProcessor<T>(predicate);
    }

    @Override
    protected void hookOnNext(T item) {
        if (this.predicate.test(item)) {
            this.submit(item);
        } else {
            this.tryRequest(this.getSubscription().get());
        }
    }
}

