/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BufferedProcessor;
import io.helidon.common.reactive.Multi;
import java.util.function.Predicate;

public class MultiDropWhileProcessor<T>
extends BufferedProcessor<T, T>
implements Multi<T> {
    private Predicate<T> predicate;
    private boolean foundNotMatching = false;

    private MultiDropWhileProcessor(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public static <T> MultiDropWhileProcessor<T> create(Predicate<T> predicate) {
        return new MultiDropWhileProcessor<T>(predicate);
    }

    @Override
    protected void hookOnNext(T item) {
        if (this.foundNotMatching || !this.predicate.test(item)) {
            this.foundNotMatching = true;
            this.submit(item);
        } else {
            this.tryRequest(this.getSubscription().get());
        }
    }
}

