/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BufferedProcessor;
import io.helidon.common.reactive.Multi;
import java.util.HashSet;
import java.util.concurrent.Flow;

public class MultiDistinctProcessor<T>
extends BufferedProcessor<T, T>
implements Multi<T> {
    private final HashSet<T> distinctSet = new HashSet();

    private MultiDistinctProcessor() {
    }

    public static <T> MultiDistinctProcessor<T> create() {
        return new MultiDistinctProcessor<T>();
    }

    @Override
    protected void hookOnCancel(Flow.Subscription subscription) {
        subscription.cancel();
    }

    @Override
    protected void hookOnNext(T item) {
        if (!this.distinctSet.contains(item)) {
            this.distinctSet.add(item);
            this.submit(item);
        } else {
            this.tryRequest(this.getSubscription().get());
        }
    }
}

