/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.StreamValidationUtils;
import io.helidon.common.reactive.SubscriberReference;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiCoupledProcessor<T, R>
implements Flow.Processor<T, R>,
Multi<R> {
    private SubscriberReference<T> passedInSubscriber;
    private SubscriberReference<? super R> outletSubscriber;
    private Flow.Publisher<R> passedInPublisher;
    private Flow.Subscriber<? super T> inletSubscriber;
    private Flow.Subscription inletSubscription;
    private Flow.Subscription passedInPublisherSubscription;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    private MultiCoupledProcessor(Flow.Subscriber<T> passedInSubscriber, Flow.Publisher<R> passedInPublisher) {
        this.passedInSubscriber = SubscriberReference.create(passedInSubscriber);
        this.passedInPublisher = passedInPublisher;
        this.inletSubscriber = this;
    }

    public static <T, R> MultiCoupledProcessor<T, R> create(Flow.Subscriber<T> passedInSubscriber, Flow.Publisher<R> passedInPublisher) {
        return new MultiCoupledProcessor<T, R>(passedInSubscriber, passedInPublisher);
    }

    @Override
    public void subscribe(final Flow.Subscriber<? super R> outletSubscriber) {
        this.outletSubscriber = SubscriberReference.create(outletSubscriber);
        this.passedInPublisher.subscribe(new Flow.Subscriber<R>(){

            @Override
            public void onSubscribe(Flow.Subscription passedInPublisherSubscription) {
                Objects.requireNonNull(passedInPublisherSubscription);
                if (Objects.nonNull(MultiCoupledProcessor.this.passedInPublisherSubscription) || MultiCoupledProcessor.this.cancelled.get()) {
                    passedInPublisherSubscription.cancel();
                    return;
                }
                MultiCoupledProcessor.this.passedInPublisherSubscription = passedInPublisherSubscription;
            }

            @Override
            public void onNext(R t) {
                Objects.requireNonNull(t);
                outletSubscriber.onNext(t);
            }

            @Override
            public void onError(Throwable t) {
                MultiCoupledProcessor.this.cancelled.set(true);
                Objects.requireNonNull(t);
                outletSubscriber.onError(t);
                MultiCoupledProcessor.this.passedInSubscriber.onError(t);
                MultiCoupledProcessor.this.inletSubscriber.onError(t);
                Optional.ofNullable(MultiCoupledProcessor.this.inletSubscription).ifPresent(Flow.Subscription::cancel);
            }

            @Override
            public void onComplete() {
                MultiCoupledProcessor.this.cancelled.set(true);
                outletSubscriber.onComplete();
                MultiCoupledProcessor.this.passedInSubscriber.onComplete();
                Optional.ofNullable(MultiCoupledProcessor.this.inletSubscription).ifPresent(Flow.Subscription::cancel);
            }
        });
        outletSubscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                StreamValidationUtils.checkRecursionDepth(2, (actDepth, t) -> outletSubscriber.onError((Throwable)t));
                MultiCoupledProcessor.this.passedInPublisherSubscription.request(n);
            }

            @Override
            public void cancel() {
                MultiCoupledProcessor.this.passedInSubscriber.onComplete();
                Optional.ofNullable(MultiCoupledProcessor.this.inletSubscription).ifPresent(Flow.Subscription::cancel);
                MultiCoupledProcessor.this.passedInPublisherSubscription.cancel();
                MultiCoupledProcessor.this.passedInSubscriber.releaseReference();
                MultiCoupledProcessor.this.outletSubscriber.releaseReference();
            }
        });
    }

    @Override
    public void onSubscribe(final Flow.Subscription inletSubscription) {
        Objects.requireNonNull(inletSubscription);
        if (Objects.nonNull(this.inletSubscription) || this.cancelled.get()) {
            inletSubscription.cancel();
            return;
        }
        this.inletSubscription = inletSubscription;
        this.passedInSubscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                StreamValidationUtils.checkRecursionDepth(5, (actDepth, t) -> MultiCoupledProcessor.this.passedInSubscriber.onError((Throwable)t));
                inletSubscription.request(n);
            }

            @Override
            public void cancel() {
                if (MultiCoupledProcessor.this.cancelled.getAndSet(true)) {
                    return;
                }
                inletSubscription.cancel();
                MultiCoupledProcessor.this.outletSubscriber.onComplete();
                MultiCoupledProcessor.this.passedInPublisherSubscription.cancel();
                MultiCoupledProcessor.this.passedInSubscriber.releaseReference();
                MultiCoupledProcessor.this.outletSubscriber.releaseReference();
            }
        });
    }

    @Override
    public void onNext(T t) {
        this.passedInSubscriber.onNext(Objects.requireNonNull(t));
    }

    @Override
    public void onError(Throwable t) {
        this.cancelled.set(true);
        this.passedInSubscriber.onError(Objects.requireNonNull(t));
        this.outletSubscriber.onError(t);
        this.passedInPublisherSubscription.cancel();
    }

    @Override
    public void onComplete() {
        this.cancelled.set(true);
        this.passedInSubscriber.onComplete();
        this.outletSubscriber.onComplete();
        this.passedInPublisherSubscription.cancel();
    }
}

