/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Collector;
import io.helidon.common.reactive.ConcatPublisher;
import io.helidon.common.reactive.FunctionalSubscriber;
import io.helidon.common.reactive.IterablePublisher;
import io.helidon.common.reactive.ListCollector;
import io.helidon.common.reactive.MultiCollectingProcessor;
import io.helidon.common.reactive.MultiDistinctProcessor;
import io.helidon.common.reactive.MultiDropWhileProcessor;
import io.helidon.common.reactive.MultiEmpty;
import io.helidon.common.reactive.MultiError;
import io.helidon.common.reactive.MultiFilterProcessor;
import io.helidon.common.reactive.MultiFirstProcessor;
import io.helidon.common.reactive.MultiFlatMapProcessor;
import io.helidon.common.reactive.MultiFromPublisher;
import io.helidon.common.reactive.MultiLimitProcessor;
import io.helidon.common.reactive.MultiMapProcessor;
import io.helidon.common.reactive.MultiNever;
import io.helidon.common.reactive.MultiPeekProcessor;
import io.helidon.common.reactive.MultiSkipProcessor;
import io.helidon.common.reactive.MultiTakeWhileProcessor;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.Subscribable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Multi<T>
extends Subscribable<T> {
    default public <U> Multi<U> map(Mapper<T, U> mapper) {
        MultiMapProcessor<T, U> processor = MultiMapProcessor.create(mapper);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> peek(Consumer<T> consumer) {
        MultiPeekProcessor<T> processor = MultiPeekProcessor.create(consumer);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> distinct() {
        MultiDistinctProcessor processor = MultiDistinctProcessor.create();
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> filter(Predicate<T> predicate) {
        MultiFilterProcessor<T> processor = MultiFilterProcessor.create(predicate);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> takeWhile(Predicate<T> predicate) {
        MultiTakeWhileProcessor<T> processor = MultiTakeWhileProcessor.create(predicate);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> dropWhile(Predicate<T> predicate) {
        MultiDropWhileProcessor<T> processor = MultiDropWhileProcessor.create(predicate);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> limit(long limit) {
        MultiLimitProcessor processor = MultiLimitProcessor.create(limit);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> skip(long skip) {
        MultiSkipProcessor processor = MultiSkipProcessor.create(skip);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> flatMap(Function<T, Flow.Publisher<T>> publisherMapper) {
        MultiFlatMapProcessor<T> processor = MultiFlatMapProcessor.fromPublisherMapper(publisherMapper);
        this.subscribe(processor);
        return processor;
    }

    default public Multi<T> flatMapIterable(Function<T, Iterable<T>> iterableMapper) {
        MultiFlatMapProcessor<T> processor = MultiFlatMapProcessor.fromIterableMapper(iterableMapper);
        this.subscribe(processor);
        return processor;
    }

    default public void forEach(Consumer<T> consumer) {
        FunctionalSubscriber<T> subscriber = new FunctionalSubscriber<T>(consumer, null, null, null);
        this.subscribe(subscriber);
    }

    default public Single<List<T>> collectList() {
        return this.collect(new ListCollector());
    }

    default public <U> Single<U> collect(Collector<T, U> collector) {
        MultiCollectingProcessor<T, U> processor = new MultiCollectingProcessor<T, U>(collector);
        this.subscribe(processor);
        return processor;
    }

    default public Single<T> first() {
        MultiFirstProcessor processor = MultiFirstProcessor.create();
        this.subscribe(processor);
        return processor;
    }

    public static <T> Multi<T> from(Flow.Publisher<T> source) {
        if (source instanceof Multi) {
            return (Multi)source;
        }
        return new MultiFromPublisher<T>(source);
    }

    public static <T> Multi<T> from(Iterable<T> iterable) {
        return Multi.from(IterablePublisher.create(iterable));
    }

    public static <T> Multi<T> just(Collection<T> items) {
        return Multi.from(items);
    }

    @SafeVarargs
    public static <T> Multi<T> just(T ... items) {
        return Multi.from(List.of(items));
    }

    public static <T> Multi<T> error(Throwable error) {
        return MultiError.create(error);
    }

    public static <T> Multi<T> empty() {
        return MultiEmpty.instance();
    }

    public static <T> Multi<T> never() {
        return MultiNever.instance();
    }

    public static <T> Multi<T> concat(Multi<T> firstMulti, Multi<T> secondMulti) {
        return ConcatPublisher.create(firstMulti, secondMulti);
    }
}

