/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.Flow;
import java.util.function.Function;

public final class MappingProcessor<SOURCE, TARGET>
implements Flow.Processor<SOURCE, TARGET> {
    private final Function<SOURCE, TARGET> resultMapper;
    private Flow.Subscriber<? super TARGET> mySubscriber;
    private Flow.Subscription subscription;

    private MappingProcessor(Function<SOURCE, TARGET> resultMapper) {
        this.resultMapper = resultMapper;
    }

    public static <S, T> MappingProcessor<S, T> create(Function<S, T> mappingFunction) {
        return new MappingProcessor<S, T>(mappingFunction);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super TARGET> subscriber) {
        this.mySubscriber = subscriber;
        subscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                if (null != MappingProcessor.this.subscription) {
                    MappingProcessor.this.subscription.request(n);
                }
            }

            @Override
            public void cancel() {
                if (null != MappingProcessor.this.subscription) {
                    MappingProcessor.this.subscription.cancel();
                }
            }
        });
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public void onNext(SOURCE item) {
        this.mySubscriber.onNext(this.resultMapper.apply(item));
    }

    @Override
    public void onError(Throwable throwable) {
        this.mySubscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.mySubscriber.onComplete();
    }
}

