/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.RequestedCounter;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

class IterablePublisher<T>
implements Flow.Publisher<T> {
    private Iterable<T> iterable;
    private AtomicBoolean cancelled = new AtomicBoolean(false);
    private AtomicBoolean completed = new AtomicBoolean(false);
    private AtomicBoolean trampolineLock = new AtomicBoolean(false);
    private final RequestedCounter requestCounter = new RequestedCounter();
    private final ReentrantLock iterateConcurrentLock = new ReentrantLock();

    private IterablePublisher() {
    }

    static <T> IterablePublisher<T> create(Iterable<T> iterable) {
        IterablePublisher<T> instance = new IterablePublisher<T>();
        instance.iterable = iterable;
        return instance;
    }

    @Override
    public void subscribe(final Flow.Subscriber<? super T> subscriber) {
        Iterator<T> iterator;
        try {
            iterator = this.iterable.iterator();
        }
        catch (Throwable t) {
            subscriber.onError(t);
            return;
        }
        subscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                IterablePublisher.this.requestCounter.increment(n, subscriber::onError);
                this.trySubmit();
            }

            private void trySubmit() {
                if (!IterablePublisher.this.trampolineLock.getAndSet(true)) {
                    try {
                        while (IterablePublisher.this.requestCounter.tryDecrement()) {
                            IterablePublisher.this.iterateConcurrentLock.lock();
                            try {
                                if (iterator.hasNext() && !IterablePublisher.this.cancelled.get()) {
                                    Object next = iterator.next();
                                    Objects.requireNonNull(next);
                                    subscriber.onNext(next);
                                    continue;
                                }
                                if (!IterablePublisher.this.completed.getAndSet(true)) {
                                    subscriber.onComplete();
                                }
                                break;
                            }
                            finally {
                                IterablePublisher.this.iterateConcurrentLock.unlock();
                            }
                        }
                    }
                    finally {
                        IterablePublisher.this.trampolineLock.set(false);
                    }
                }
            }

            @Override
            public void cancel() {
                IterablePublisher.this.cancelled.set(true);
            }
        });
    }
}

