/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Flow;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

final class SingleToFuture<T>
extends CompletableFuture<T>
implements Flow.Subscriber<T> {
    private final AtomicReference<Flow.Subscription> ref = new AtomicReference();

    SingleToFuture() {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Flow.Subscription s;
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (cancelled && (s = (Flow.Subscription)this.ref.getAndSet(null)) != null) {
            s.cancel();
        }
        return cancelled;
    }

    @Override
    public void onSubscribe(Flow.Subscription next) {
        Flow.Subscription current = this.ref.getAndSet(next);
        Objects.requireNonNull(next, "Subscription cannot be null");
        if (current != null) {
            next.cancel();
            current.cancel();
        } else {
            next.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T item) {
        Flow.Subscription s = this.ref.getAndSet(null);
        if (s != null) {
            super.complete(item);
            s.cancel();
        }
    }

    @Override
    public void onError(Throwable ex) {
        if (this.ref.getAndSet(null) != null) {
            super.completeExceptionally(ex);
        }
    }

    @Override
    public void onComplete() {
        if (this.ref.getAndSet(null) != null) {
            super.completeExceptionally(new IllegalStateException("Completed without value"));
        }
    }

    @Override
    public boolean complete(T value) {
        throw new UnsupportedOperationException("This future cannot be completed manually");
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        throw new UnsupportedOperationException("This future cannot be completed manually");
    }
}

