/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.BaseProcessor;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.Multi;
import java.util.Objects;

final class SingleMultiMappingProcessor<T, U>
extends BaseProcessor<T, U>
implements Multi<U> {
    private Flow.Publisher<U> delegate;
    private final Mapper<T, Flow.Publisher<U>> mapper;

    SingleMultiMappingProcessor(Mapper<T, Flow.Publisher<U>> mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null!");
    }

    @Override
    protected void hookOnNext(T item) {
        Flow.Publisher value = (Flow.Publisher)this.mapper.map(item);
        if (value == null) {
            this.onError(new IllegalStateException("Mapper returned a null value"));
        } else {
            this.delegate = value;
        }
    }

    @Override
    protected void hookOnComplete() {
        if (this.delegate != null) {
            this.doSubscribe(this.delegate);
        }
    }
}

