/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SingleEmpty;
import io.helidon.common.reactive.SingleError;
import io.helidon.common.reactive.SingleExactlyOneProcessor;
import io.helidon.common.reactive.SingleJust;
import io.helidon.common.reactive.SingleMappingProcessor;
import io.helidon.common.reactive.SingleMultiMappingProcessor;
import io.helidon.common.reactive.SingleNever;
import io.helidon.common.reactive.SingleToFuture;
import io.helidon.common.reactive.Subscribable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface Single<T>
extends Subscribable<T> {
    default public <U> Single<U> map(Mapper<T, U> mapper) {
        SingleMappingProcessor<T, U> processor = new SingleMappingProcessor<T, U>(mapper);
        this.subscribe(processor);
        return processor;
    }

    default public <U> Multi<U> mapMany(Mapper<T, Flow.Publisher<U>> mapper) {
        SingleMultiMappingProcessor<T, U> processor = new SingleMultiMappingProcessor<T, U>(mapper);
        this.subscribe(processor);
        return processor;
    }

    default public CompletionStage<T> toStage() {
        try {
            SingleToFuture subscriber = new SingleToFuture();
            this.subscribe(subscriber);
            return subscriber;
        }
        catch (Throwable ex) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(ex);
            return future;
        }
    }

    default public T get() throws InterruptedException, ExecutionException {
        return this.toStage().toCompletableFuture().get();
    }

    default public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.toStage().toCompletableFuture().get(timeout, unit);
    }

    public static <T> Single<T> from(Flow.Publisher<T> source) {
        Objects.requireNonNull(source, "source is null!");
        if (source instanceof Single) {
            return (Single)source;
        }
        SingleExactlyOneProcessor processor = new SingleExactlyOneProcessor();
        source.subscribe(processor);
        return processor;
    }

    public static <T> Single<T> just(T item) {
        return new SingleJust<T>(item);
    }

    public static <T> Single<T> error(Throwable error) {
        return new SingleError(error);
    }

    public static <T> Single<T> empty() {
        return SingleEmpty.instance();
    }

    public static <T> Single<T> never() {
        return SingleNever.instance();
    }
}

