/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.BaseProcessor;
import io.helidon.common.reactive.Multi;
import java.util.Objects;

final class MultiMappingProcessor<T, U>
extends BaseProcessor<T, U>
implements Multi<U> {
    private final Mapper<T, U> mapper;

    MultiMappingProcessor(Mapper<T, U> mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null!");
    }

    @Override
    protected void hookOnNext(T item) {
        Object value = this.mapper.map(item);
        if (value == null) {
            this.onError(new IllegalStateException("Mapper returned a null value"));
        } else {
            this.submit(value);
        }
    }
}

