/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.valve.Pausable;
import io.helidon.common.reactive.valve.Valve;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class PublisherValve<T>
implements Valve<T> {
    private static final Logger LOGGER = Logger.getLogger(PublisherValve.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final Flow.Publisher<T> publisher;
    private volatile Subscriber subscriber;
    private volatile boolean paused = false;
    private boolean recordedDemand = false;

    PublisherValve(Flow.Publisher<T> publisher) {
        Objects.requireNonNull(publisher, "Parameter 'publisher' is null!");
        this.publisher = publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(BiConsumer<T, Pausable> onData, Consumer<Throwable> onError, Runnable onComplete) {
        PublisherValve publisherValve = this;
        synchronized (publisherValve) {
            if (this.subscriber != null) {
                throw new IllegalStateException("Handler is already registered!");
            }
            this.subscriber = new Subscriber(onData, onError, onComplete);
        }
        this.paused = false;
        this.publisher.subscribe(this.subscriber);
    }

    @Override
    public void pause() {
        this.lock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resume() {
        boolean processDemand = false;
        this.lock.lock();
        try {
            if (this.paused && this.subscriber != null) {
                this.paused = false;
                if (this.recordedDemand) {
                    processDemand = true;
                    this.recordedDemand = false;
                }
            }
        }
        finally {
            this.lock.unlock();
            if (processDemand) {
                this.subscriber.subscription.request(1L);
            }
        }
    }

    private boolean recordDemand() {
        this.lock.lock();
        try {
            if (this.paused) {
                this.recordedDemand = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Subscriber
    implements Flow.Subscriber<T> {
        private final BiConsumer<T, Pausable> onData;
        private final Consumer<Throwable> onError;
        private final Runnable onComplete;
        private volatile Flow.Subscription subscription;

        Subscriber(BiConsumer<T, Pausable> onData, Consumer<Throwable> onError, Runnable onComplete) {
            Objects.requireNonNull(onData, "Parameter 'onData' is null!");
            this.onData = onData;
            this.onError = onError;
            this.onComplete = onComplete;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void onNext(T item) {
            this.onData.accept(item, PublisherValve.this);
            if (!PublisherValve.this.paused || !PublisherValve.this.recordDemand()) {
                this.subscription.request(1L);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.onError != null) {
                this.onError.accept(throwable);
            } else {
                LOGGER.log(Level.WARNING, "Unhandled throwable!", throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.onComplete != null) {
                this.onComplete.run();
            }
        }
    }
}

