/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.ReactiveStreamsAdapter;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.UnicastProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class SubmissionPublisher<T>
implements Flow.Publisher<T>,
AutoCloseable {
    private final Flux<T> flux;
    private final FluxSink<T> sink;
    private final AtomicInteger numberOfSubscribers;

    public SubmissionPublisher(Executor executor, int maxBufferCapacity) {
        this(Schedulers.fromExecutor((Executor)executor), maxBufferCapacity);
    }

    public SubmissionPublisher(int maxBufferCapacity) {
        this(Schedulers.immediate(), maxBufferCapacity);
    }

    public SubmissionPublisher() {
        this(Schedulers.immediate(), Flow.defaultBufferSize());
    }

    private SubmissionPublisher(Scheduler scheduler, int maxBufferCapacity) {
        if (scheduler == null) {
            throw new NullPointerException();
        }
        if (maxBufferCapacity <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        UnicastProcessor processor = UnicastProcessor.create();
        this.sink = processor.sink();
        this.flux = processor.publish(maxBufferCapacity).autoConnect().subscribeOn(Schedulers.immediate()).publishOn(scheduler);
        this.numberOfSubscribers = new AtomicInteger(0);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        this.flux.subscribe(new OnCancelSubscriber<T>(subscriber, this::onCancel));
        this.numberOfSubscribers.incrementAndGet();
    }

    private void onCancel(Subscription subscription) {
        this.numberOfSubscribers.decrementAndGet();
    }

    public void submit(T item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.sink.next(item);
    }

    public void offer(T item, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        this.submit(item);
    }

    public void closeExceptionally(Throwable error) {
        if (error == null) {
            throw new NullPointerException();
        }
        this.sink.error(error);
    }

    @Override
    public void close() {
        this.sink.complete();
    }

    public int getNumberOfSubscribers() {
        return this.numberOfSubscribers.get();
    }

    public boolean hasSubscribers() {
        return this.getNumberOfSubscribers() > 0;
    }

    private static class OnCancelSubscriber<T>
    implements Subscriber<T> {
        private final Subscriber<T> delegate;
        private final Consumer<Subscription> onCancel;

        OnCancelSubscriber(Flow.Subscriber<T> subscriber, Consumer<Subscription> onCancel) {
            this.delegate = ReactiveStreamsAdapter.subscriberFromFlow(subscriber);
            this.onCancel = onCancel;
        }

        public void onSubscribe(final Subscription s) {
            this.delegate.onSubscribe(new Subscription(){

                public void request(long n) {
                    s.request(n);
                }

                public void cancel() {
                    s.cancel();
                    onCancel.accept(s);
                }
            });
        }

        public void onNext(T t) {
            this.delegate.onNext(t);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }
}

