/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.valve.Pausable;
import io.helidon.common.reactive.valve.PausableRegistry;
import java.util.function.BiConsumer;

abstract class RetryingPausableRegistry<T>
extends PausableRegistry<T> {
    RetryingPausableRegistry() {
    }

    @Override
    protected void tryProcess() {
        if (this.canProcess()) {
            try {
                T data;
                BiConsumer<T, Pausable> onData = this.getOnData();
                boolean breakByPause = false;
                while ((data = this.moreData()) != null) {
                    onData.accept(data, this);
                    if (this.canContinueProcessing()) continue;
                    breakByPause = true;
                    break;
                }
                if (!breakByPause && this.getOnComplete() != null) {
                    this.getOnComplete().run();
                }
            }
            catch (Throwable thr) {
                this.handleError(thr);
                this.releaseProcessing();
            }
        }
    }

    protected abstract T moreData() throws Throwable;
}

