/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.valve.Pausable;
import io.helidon.common.reactive.valve.Valve;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class DetachedValve<T>
implements Valve<T> {
    private static final int INTERNAL_INDEX = 0;
    private static final int EXTERNAL_INDEX = 1;
    private final boolean[] paused = new boolean[]{false, false};
    private final Lock lock = new ReentrantLock();
    private final Valve<T> delegate;
    private final ExecutorService executorService;

    DetachedValve(Valve<T> delegate, ExecutorService executorService) {
        this.delegate = delegate;
        this.executorService = executorService;
    }

    @Override
    public void handle(BiConsumer<T, Pausable> onData, Consumer<Throwable> onError, Runnable onComplete) {
        this.delegate.handle((T t, Pausable p) -> {
            this.pause(0);
            CompletableFuture.runAsync(() -> onData.accept(t, this), this.executorService).whenComplete((vd, thr) -> {
                if (thr == null) {
                    this.resume(0);
                } else {
                    this.executorService.submit(() -> onError.accept((Throwable)thr));
                }
            });
        }, (Throwable t) -> this.executorService.submit(() -> onError.accept((Throwable)t)), () -> this.executorService.submit(onComplete));
    }

    private void pause(int index) {
        this.lock.lock();
        try {
            boolean callIt = !this.paused[0] && !this.paused[1];
            this.paused[index] = true;
            if (callIt) {
                this.delegate.pause();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void resume(int index) {
        this.lock.lock();
        try {
            boolean callIt = this.paused[index] && !this.paused[index == 0 ? 1 : 0];
            this.paused[index] = false;
            if (callIt) {
                this.delegate.resume();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void pause() {
        this.pause(1);
    }

    @Override
    public void resume() {
        this.resume(1);
    }
}

