/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.parameters;

import io.helidon.common.parameters.Parameters;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class ParametersSingleValueMap
implements Parameters {
    private final String component;
    private final Map<String, String> params;

    ParametersSingleValueMap(String component, Map<String, String> params) {
        this.component = component;
        this.params = params;
    }

    @Override
    public List<String> all(String name) throws NoSuchElementException {
        String value = this.params.get(name);
        if (value == null) {
            throw new NoSuchElementException("This " + this.component + " does not contain parameter named \"" + name + "\"");
        }
        return List.of(value);
    }

    @Override
    public String value(String name) throws NoSuchElementException {
        String value = this.params.get(name);
        if (value == null) {
            throw new NoSuchElementException("This " + this.component + " does not contain parameter named \"" + name + "\"");
        }
        return value;
    }

    @Override
    public boolean contains(String name) {
        return this.params.containsKey(name);
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public Set<String> names() {
        return Set.copyOf(this.params.keySet());
    }

    @Override
    public String component() {
        return this.component;
    }

    public String toString() {
        return this.component + ": " + String.valueOf(this.params);
    }
}

