/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceConfig;
import io.helidon.common.pki.PemKeysBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.common.pki.PemKeysBlueprint")
public interface PemKeys
extends PemKeysBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PemKeys instance) {
        return (Builder)PemKeys.builder().from(instance);
    }

    public static PemKeys create(Config config) {
        return ((Builder)PemKeys.builder().config(config)).buildPrototype();
    }

    public static PemKeys create() {
        return PemKeys.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, PemKeys>
    implements io.helidon.common.Builder<Builder, PemKeys> {
        private Builder() {
        }

        public PemKeys buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.PemKeysImpl(this);
        }

        public PemKeys build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PemKeys>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE>,
    PemKeys {
        private Config config;
        private Resource key;
        private char[] keyPassphrase;
        private Resource publicKey;
        private Resource certChain;
        private Resource certificates;

        protected BuilderBase() {
        }

        public BUILDER from(PemKeys prototype) {
            this.key(prototype.key());
            this.keyPassphrase(prototype.keyPassphrase());
            this.publicKey(prototype.publicKey());
            this.certChain(prototype.certChain());
            this.certificates(prototype.certificates());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.key(builder.key());
            this.keyPassphrase(builder.keyPassphrase());
            this.publicKey(builder.publicKey());
            this.certChain(builder.certChain());
            this.certificates(builder.certificates());
            return (BUILDER)((BuilderBase)this.self());
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("key.resource").map(ResourceConfig::create).ifPresent(this::key);
            config.get("key.passphrase").asString().map(String::toCharArray).ifPresent(this::keyPassphrase);
            config.get("public-key.resource").map(ResourceConfig::create).ifPresent(this::publicKey);
            config.get("cert-chain.resource").map(ResourceConfig::create).ifPresent(this::certChain);
            config.get("certificates.resource").map(ResourceConfig::create).ifPresent(this::certificates);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER key(Optional<? extends Resource> key) {
            Objects.requireNonNull(key);
            this.key = key.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearKey() {
            this.key = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER key(Resource key) {
            Objects.requireNonNull(key);
            this.key = key = (Resource)this.resolveBuilder(key);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER key(ResourceConfig keyConfig) {
            Objects.requireNonNull(keyConfig);
            this.key = Resource.create((ResourceConfig)keyConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER key(Consumer<ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ResourceConfig.Builder builder = ResourceConfig.builder();
            consumer.accept(builder);
            this.key(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER keyPassphrase(Optional<? extends char[]> keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearKeyPassphrase() {
            this.keyPassphrase = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyPassphrase(char[] keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyPassphrase(String keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase.toCharArray();
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER publicKey(Optional<? extends Resource> publicKey) {
            Objects.requireNonNull(publicKey);
            this.publicKey = publicKey.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPublicKey() {
            this.publicKey = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER publicKey(Resource publicKey) {
            Objects.requireNonNull(publicKey);
            this.publicKey = publicKey = (Resource)this.resolveBuilder(publicKey);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER publicKey(ResourceConfig publicKeyConfig) {
            Objects.requireNonNull(publicKeyConfig);
            this.publicKey = Resource.create((ResourceConfig)publicKeyConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER publicKey(Consumer<ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ResourceConfig.Builder builder = ResourceConfig.builder();
            consumer.accept(builder);
            this.publicKey(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER certChain(Optional<? extends Resource> certChain) {
            Objects.requireNonNull(certChain);
            this.certChain = certChain.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCertChain() {
            this.certChain = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certChain(Resource certChain) {
            Objects.requireNonNull(certChain);
            this.certChain = certChain = (Resource)this.resolveBuilder(certChain);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certChain(ResourceConfig certChainConfig) {
            Objects.requireNonNull(certChainConfig);
            this.certChain = Resource.create((ResourceConfig)certChainConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certChain(Consumer<ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ResourceConfig.Builder builder = ResourceConfig.builder();
            consumer.accept(builder);
            this.certChain(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER certificates(Optional<? extends Resource> certificates) {
            Objects.requireNonNull(certificates);
            this.certificates = certificates.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCertificates() {
            this.certificates = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certificates(Resource certificates) {
            Objects.requireNonNull(certificates);
            this.certificates = certificates = (Resource)this.resolveBuilder(certificates);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certificates(ResourceConfig certificatesConfig) {
            Objects.requireNonNull(certificatesConfig);
            this.certificates = Resource.create((ResourceConfig)certificatesConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certificates(Consumer<ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ResourceConfig.Builder builder = ResourceConfig.builder();
            consumer.accept(builder);
            this.certificates(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public Optional<Resource> key() {
            return Optional.ofNullable(this.key);
        }

        @Override
        public Optional<char[]> keyPassphrase() {
            return Optional.ofNullable(this.keyPassphrase);
        }

        @Override
        public Optional<Resource> publicKey() {
            return Optional.ofNullable(this.publicKey);
        }

        @Override
        public Optional<Resource> certChain() {
            return Optional.ofNullable(this.certChain);
        }

        @Override
        public Optional<Resource> certificates() {
            return Optional.ofNullable(this.certificates);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "PemKeysBuilder{key=" + String.valueOf(this.key) + ",keyPassphrase=" + (this.keyPassphrase == null ? "null" : "****") + ",publicKey=" + String.valueOf(this.publicKey) + ",certChain=" + String.valueOf(this.certChain) + ",certificates=" + String.valueOf(this.certificates) + "}";
        }

        protected static class PemKeysImpl
        implements PemKeys {
            private final Optional<Resource> key;
            private final Optional<char[]> keyPassphrase;
            private final Optional<Resource> publicKey;
            private final Optional<Resource> certChain;
            private final Optional<Resource> certificates;

            protected PemKeysImpl(BuilderBase<?, ?> builder) {
                this.key = builder.key();
                this.keyPassphrase = builder.keyPassphrase();
                this.publicKey = builder.publicKey();
                this.certChain = builder.certChain();
                this.certificates = builder.certificates();
            }

            @Override
            public Optional<Resource> key() {
                return this.key;
            }

            @Override
            public Optional<char[]> keyPassphrase() {
                return this.keyPassphrase;
            }

            @Override
            public Optional<Resource> publicKey() {
                return this.publicKey;
            }

            @Override
            public Optional<Resource> certChain() {
                return this.certChain;
            }

            @Override
            public Optional<Resource> certificates() {
                return this.certificates;
            }

            public String toString() {
                return "PemKeys{key=" + String.valueOf(this.key) + ",keyPassphrase=" + (this.keyPassphrase.isPresent() ? "****" : "null") + ",publicKey=" + String.valueOf(this.publicKey) + ",certChain=" + String.valueOf(this.certChain) + ",certificates=" + String.valueOf(this.certificates) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PemKeys)) {
                    return false;
                }
                PemKeys other = (PemKeys)o;
                return Objects.equals(this.key, other.key()) && Objects.equals(this.keyPassphrase, other.keyPassphrase()) && Objects.equals(this.publicKey, other.publicKey()) && Objects.equals(this.certChain, other.certChain()) && Objects.equals(this.certificates, other.certificates());
            }

            public int hashCode() {
                return Objects.hash(this.key, this.keyPassphrase, this.publicKey, this.certChain, this.certificates);
            }
        }
    }
}

