/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceConfig;
import io.helidon.common.pki.KeystoreKeysBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.common.pki.KeystoreKeysBlueprint")
public interface KeystoreKeys
extends KeystoreKeysBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KeystoreKeys instance) {
        return (Builder)KeystoreKeys.builder().from(instance);
    }

    public static KeystoreKeys create(Config config) {
        return ((Builder)KeystoreKeys.builder().config(config)).buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, KeystoreKeys>
    implements io.helidon.common.Builder<Builder, KeystoreKeys> {
        private Builder() {
        }

        public KeystoreKeys buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.KeystoreKeysImpl(this);
        }

        public KeystoreKeys build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends KeystoreKeys>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE>,
    KeystoreKeys {
        private Config config;
        private Resource keystore;
        private String type = "PKCS12";
        private char[] passphrase;
        private String keyAlias;
        private char[] keyPassphrase;
        private String certAlias;
        private String certChainAlias;
        private final List<String> certAliases = new ArrayList<String>();
        private boolean trustStore = false;

        protected BuilderBase() {
        }

        public BUILDER from(KeystoreKeys prototype) {
            this.keystore(prototype.keystore());
            this.type(prototype.type());
            this.passphrase(prototype.passphrase());
            this.keyAlias(prototype.keyAlias());
            this.keyPassphrase(prototype.keyPassphrase());
            this.certAlias(prototype.certAlias());
            this.certChainAlias(prototype.certChainAlias());
            this.addCertAliases(prototype.certAliases());
            this.trustStore(prototype.trustStore());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (builder.keystore() != null) {
                this.keystore(builder.keystore());
            }
            if (builder.type() != null) {
                this.type(builder.type());
            }
            this.passphrase(builder.passphrase());
            this.keyAlias(builder.keyAlias());
            this.keyPassphrase(builder.keyPassphrase());
            this.certAlias(builder.certAlias());
            this.certChainAlias(builder.certChainAlias());
            this.addCertAliases(builder.certAliases());
            this.trustStore(builder.trustStore());
            return (BUILDER)((BuilderBase)this.self());
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.keystore == null) {
                collector.fatal(this.getClass(), "Property \"resource\" is required, but not set");
            }
            collector.collect().checkValid();
        }

        public BUILDER keystorePassphrase(String passphrase) {
            KeystoreKeysBlueprint.CustomMethods.keystorePassphrase(this, passphrase);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("resource").map(ResourceConfig::create).ifPresent(this::keystore);
            config.get("type").as(String.class).ifPresent(this::type);
            config.get("passphrase").asString().map(String::toCharArray).ifPresent(this::passphrase);
            config.get("key.alias").as(String.class).ifPresent(this::keyAlias);
            config.get("key.passphrase").asString().map(String::toCharArray).ifPresent(this::keyPassphrase);
            config.get("cert.alias").as(String.class).ifPresent(this::certAlias);
            config.get("cert-chain.alias").as(String.class).ifPresent(this::certChainAlias);
            config.get("trust-store").as(Boolean.class).ifPresent(this::trustStore);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keystore(Resource keystore) {
            Objects.requireNonNull(keystore);
            this.keystore = keystore = (Resource)this.resolveBuilder(keystore);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keystore(ResourceConfig keystoreConfig) {
            Objects.requireNonNull(keystoreConfig);
            this.keystore = Resource.create((ResourceConfig)keystoreConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keystore(Consumer<ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ResourceConfig.Builder builder = ResourceConfig.builder();
            consumer.accept(builder);
            this.keystore(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER type(String type) {
            Objects.requireNonNull(type);
            this.type = type;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER passphrase(Optional<? extends char[]> passphrase) {
            Objects.requireNonNull(passphrase);
            this.passphrase = passphrase.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPassphrase() {
            this.passphrase = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER passphrase(char[] passphrase) {
            Objects.requireNonNull(passphrase);
            this.passphrase = passphrase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER passphrase(String passphrase) {
            Objects.requireNonNull(passphrase);
            this.passphrase = passphrase.toCharArray();
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER keyAlias(Optional<? extends String> keyAlias) {
            Objects.requireNonNull(keyAlias);
            this.keyAlias = keyAlias.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearKeyAlias() {
            this.keyAlias = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyAlias(String keyAlias) {
            Objects.requireNonNull(keyAlias);
            this.keyAlias = keyAlias;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER keyPassphrase(Optional<? extends char[]> keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearKeyPassphrase() {
            this.keyPassphrase = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyPassphrase(char[] keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyPassphrase(String keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase.toCharArray();
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER certAlias(Optional<? extends String> certAlias) {
            Objects.requireNonNull(certAlias);
            this.certAlias = certAlias.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCertAlias() {
            this.certAlias = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certAlias(String certAlias) {
            Objects.requireNonNull(certAlias);
            this.certAlias = certAlias;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER certChainAlias(Optional<? extends String> certChainAlias) {
            Objects.requireNonNull(certChainAlias);
            this.certChainAlias = certChainAlias.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCertChainAlias() {
            this.certChainAlias = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certChainAlias(String certChainAlias) {
            Objects.requireNonNull(certChainAlias);
            this.certChainAlias = certChainAlias;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certAliases(List<? extends String> certAliases) {
            Objects.requireNonNull(certAliases);
            this.certAliases.clear();
            this.certAliases.addAll(certAliases);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCertAliases(List<? extends String> certAliases) {
            Objects.requireNonNull(certAliases);
            this.certAliases.addAll(certAliases);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCertAlias(String certAlias) {
            Objects.requireNonNull(certAlias);
            this.certAliases.add(certAlias);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER trustStore(boolean trustStore) {
            this.trustStore = trustStore;
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public Resource keystore() {
            return this.keystore;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Optional<char[]> passphrase() {
            return Optional.ofNullable(this.passphrase);
        }

        @Override
        public Optional<String> keyAlias() {
            return Optional.ofNullable(this.keyAlias);
        }

        @Override
        public Optional<char[]> keyPassphrase() {
            return Optional.ofNullable(this.keyPassphrase);
        }

        @Override
        public Optional<String> certAlias() {
            return Optional.ofNullable(this.certAlias);
        }

        @Override
        public Optional<String> certChainAlias() {
            return Optional.ofNullable(this.certChainAlias);
        }

        @Override
        public List<String> certAliases() {
            return this.certAliases;
        }

        @Override
        public boolean trustStore() {
            return this.trustStore;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "KeystoreKeysBuilder{keystore=" + String.valueOf(this.keystore) + ",type=" + this.type + ",passphrase=" + (this.passphrase == null ? "null" : "****") + ",keyAlias=" + this.keyAlias + ",keyPassphrase=" + (this.keyPassphrase == null ? "null" : "****") + ",certAlias=" + this.certAlias + ",certChainAlias=" + this.certChainAlias + ",certAliases=" + String.valueOf(this.certAliases) + ",trustStore=" + this.trustStore + "}";
        }

        protected static class KeystoreKeysImpl
        implements KeystoreKeys {
            private final Resource keystore;
            private final String type;
            private final Optional<char[]> passphrase;
            private final Optional<String> keyAlias;
            private final Optional<char[]> keyPassphrase;
            private final Optional<String> certAlias;
            private final Optional<String> certChainAlias;
            private final List<String> certAliases;
            private final boolean trustStore;

            protected KeystoreKeysImpl(BuilderBase<?, ?> builder) {
                this.keystore = builder.keystore();
                this.type = builder.type();
                this.passphrase = builder.passphrase();
                this.keyAlias = builder.keyAlias();
                this.keyPassphrase = builder.keyPassphrase();
                this.certAlias = builder.certAlias();
                this.certChainAlias = builder.certChainAlias();
                this.certAliases = List.copyOf(builder.certAliases());
                this.trustStore = builder.trustStore();
            }

            @Override
            public Resource keystore() {
                return this.keystore;
            }

            @Override
            public String type() {
                return this.type;
            }

            @Override
            public Optional<char[]> passphrase() {
                return this.passphrase;
            }

            @Override
            public Optional<String> keyAlias() {
                return this.keyAlias;
            }

            @Override
            public Optional<char[]> keyPassphrase() {
                return this.keyPassphrase;
            }

            @Override
            public Optional<String> certAlias() {
                return this.certAlias;
            }

            @Override
            public Optional<String> certChainAlias() {
                return this.certChainAlias;
            }

            @Override
            public List<String> certAliases() {
                return this.certAliases;
            }

            @Override
            public boolean trustStore() {
                return this.trustStore;
            }

            public String toString() {
                return "KeystoreKeys{keystore=" + String.valueOf(this.keystore) + ",type=" + this.type + ",passphrase=" + (this.passphrase.isPresent() ? "****" : "null") + ",keyAlias=" + String.valueOf(this.keyAlias) + ",keyPassphrase=" + (this.keyPassphrase.isPresent() ? "****" : "null") + ",certAlias=" + String.valueOf(this.certAlias) + ",certChainAlias=" + String.valueOf(this.certChainAlias) + ",certAliases=" + String.valueOf(this.certAliases) + ",trustStore=" + this.trustStore + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KeystoreKeys)) {
                    return false;
                }
                KeystoreKeys other = (KeystoreKeys)o;
                return Objects.equals(this.keystore, other.keystore()) && Objects.equals(this.type, other.type()) && Objects.equals(this.passphrase, other.passphrase()) && Objects.equals(this.keyAlias, other.keyAlias()) && Objects.equals(this.keyPassphrase, other.keyPassphrase()) && Objects.equals(this.certAlias, other.certAlias()) && Objects.equals(this.certChainAlias, other.certChainAlias()) && Objects.equals(this.certAliases, other.certAliases()) && this.trustStore == other.trustStore();
            }

            public int hashCode() {
                return Objects.hash(this.keystore, this.type, this.passphrase, this.keyAlias, this.keyPassphrase, this.certAlias, this.certChainAlias, this.certAliases, this.trustStore);
            }
        }
    }
}

