/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.builder.api.Prototype;
import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceException;
import io.helidon.common.pki.Keys;
import io.helidon.common.pki.KeystoreKeys;
import io.helidon.common.pki.PemKeys;
import io.helidon.common.pki.PemReader;
import io.helidon.common.pki.PkiException;
import io.helidon.common.pki.PkiUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

class KeysBuilderInterceptor
implements Prototype.BuilderInterceptor<Keys.BuilderBase<?, ?>> {
    private static final System.Logger LOGGER = System.getLogger(Keys.class.getName());

    KeysBuilderInterceptor() {
    }

    public Keys.BuilderBase<?, ?> intercept(Keys.BuilderBase<?, ?> target) {
        try {
            target.keystore().ifPresent(keystoreConfig -> this.updateFromKeystore(target, (KeystoreKeys)keystoreConfig));
            target.pem().ifPresent(pemConfig -> this.updateFromPem(target, (PemKeys)pemConfig));
            if (target.publicKey().isEmpty() && target.publicCert().isPresent()) {
                target.publicKey(target.publicCert().get().getPublicKey());
            }
            return target;
        }
        catch (ResourceException e) {
            throw new PkiException("Failed to load key configuration", e);
        }
    }

    private void updateFromPem(Keys.BuilderBase<?, ?> builder, PemKeys pemConfig) {
        if (builder.privateKey().isEmpty()) {
            pemConfig.key().ifPresent(resource -> {
                char[] passphrase = pemConfig.keyPassphrase().orElse(null);
                builder.privateKey(PemReader.readPrivateKey(resource.stream(), passphrase));
            });
        }
        if (builder.publicKey().isEmpty()) {
            pemConfig.publicKey().ifPresent(resource -> builder.publicKey(PemReader.readPublicKey(resource.stream())));
        }
        List certs = pemConfig.certChain().map(resource -> PemReader.readCertificates(resource.stream())).orElseGet(List::of);
        certs.forEach(builder::addCertChain);
        if (!certs.isEmpty() && builder.publicCert().isEmpty()) {
            builder.publicCert((X509Certificate)certs.get(0));
        }
        pemConfig.certificates().stream().map(resource -> PemReader.readCertificates(resource.stream())).flatMap(Collection::stream).forEach(builder::addCert);
    }

    private void updateFromKeystore(Keys.BuilderBase<?, ?> builder, KeystoreKeys keystoreConfig) {
        KeyStore keyStore;
        char[] keystorePassword = keystoreConfig.passphrase().orElseGet(() -> new char[0]);
        char[] keyPassword = keystoreConfig.keyPassphrase().orElse(keystorePassword);
        String keystoreType = keystoreConfig.type();
        Resource keystoreResource = keystoreConfig.keystore();
        try (InputStream keystoreStream = keystoreResource.stream();){
            keyStore = PkiUtil.loadKeystore(keystoreType, keystoreStream, keystorePassword, keystoreResource.location());
        }
        catch (IOException e) {
            throw new PkiException("Failed to read keystore from its resource: " + String.valueOf(keystoreResource), e);
        }
        Optional<String> keyAliasConfigured = keystoreConfig.keyAlias();
        String keyAlias = keyAliasConfigured.orElse("1");
        if (builder.privateKey().isEmpty()) {
            boolean guessing = keyAliasConfigured.isEmpty();
            try {
                builder.privateKey(PkiUtil.loadPrivateKey(keyStore, keyAlias, keyPassword));
            }
            catch (Exception e) {
                if (guessing) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Failed to read private key from default alias", (Throwable)e);
                }
                throw e;
            }
        }
        List<X509Certificate> certChain = null;
        if (builder.certChain().isEmpty()) {
            Optional<String> certChainAliasConfigured = keystoreConfig.certChainAlias();
            boolean guessing = certChainAliasConfigured.isEmpty();
            String certChainAlias = certChainAliasConfigured.orElse(keyAlias);
            try {
                certChain = PkiUtil.loadCertChain(keyStore, certChainAlias);
                certChain.forEach(builder::addCertChain);
            }
            catch (Exception e) {
                if (guessing) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Failed to certificate chain from alias \"" + certChainAlias + "\"", (Throwable)e);
                }
                throw e;
            }
        }
        if (builder.publicCert().isEmpty()) {
            Optional<String> publicCertAliasConfigured = keystoreConfig.certAlias();
            if (publicCertAliasConfigured.isEmpty()) {
                if (!builder.certChain().isEmpty()) {
                    builder.publicCert(builder.certChain().get(0));
                }
            } else {
                builder.publicCert(PkiUtil.loadCertificate(keyStore, publicCertAliasConfigured.get()));
            }
        }
        if (keystoreConfig.trustStore()) {
            PkiUtil.loadCertificates(keyStore).forEach(builder::addCert);
        } else {
            keystoreConfig.certAliases().forEach(it -> builder.addCert(PkiUtil.loadCertificate(keyStore, it)));
        }
    }
}

