/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.pki.KeysBlueprint;
import io.helidon.common.pki.KeysBuilderInterceptor;
import io.helidon.common.pki.KeystoreKeys;
import io.helidon.common.pki.PemKeys;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.common.pki.KeysBlueprint")
public interface Keys
extends KeysBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Keys instance) {
        return (Builder)Keys.builder().from(instance);
    }

    public static Keys create(Config config) {
        return ((Builder)Keys.builder().config(config)).buildPrototype();
    }

    public static Keys create() {
        return Keys.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Keys>
    implements io.helidon.common.Builder<Builder, Keys> {
        private Builder() {
        }

        public Keys buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.KeysImpl(this);
        }

        public Keys build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Keys>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE>,
    Keys {
        private Config config;
        private KeystoreKeys keystore;
        private PemKeys pem;
        private PublicKey publicKey;
        private PrivateKey privateKey;
        private X509Certificate publicCert;
        private final List<X509Certificate> certChain = new ArrayList<X509Certificate>();
        private final List<X509Certificate> certs = new ArrayList<X509Certificate>();

        protected BuilderBase() {
        }

        public BUILDER from(Keys prototype) {
            this.keystore(prototype.keystore());
            this.pem(prototype.pem());
            this.publicKey(prototype.publicKey());
            this.privateKey(prototype.privateKey());
            this.publicCert(prototype.publicCert());
            this.addCertChain(prototype.certChain());
            this.addCerts(prototype.certs());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.keystore(builder.keystore());
            this.pem(builder.pem());
            this.publicKey(builder.publicKey());
            this.privateKey(builder.privateKey());
            this.publicCert(builder.publicCert());
            this.addCertChain(builder.certChain());
            this.addCerts(builder.certs());
            return (BUILDER)((BuilderBase)this.self());
        }

        protected void preBuildPrototype() {
            new KeysBuilderInterceptor().intercept(this);
        }

        protected void validatePrototype() {
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("keystore").map(KeystoreKeys::create).ifPresent(this::keystore);
            config.get("pem").map(PemKeys::create).ifPresent(this::pem);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER keystore(Optional<? extends KeystoreKeys> keystore) {
            Objects.requireNonNull(keystore);
            this.keystore = keystore.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearKeystore() {
            this.keystore = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keystore(KeystoreKeys keystore) {
            Objects.requireNonNull(keystore);
            this.keystore = keystore = (KeystoreKeys)this.resolveBuilder(keystore);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keystore(Consumer<KeystoreKeys.Builder> consumer) {
            Objects.requireNonNull(consumer);
            KeystoreKeys.Builder builder = KeystoreKeys.builder();
            consumer.accept(builder);
            this.keystore(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER pem(Optional<? extends PemKeys> pem) {
            Objects.requireNonNull(pem);
            this.pem = pem.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPem() {
            this.pem = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER pem(PemKeys pem) {
            Objects.requireNonNull(pem);
            this.pem = pem = (PemKeys)this.resolveBuilder(pem);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER pem(Consumer<PemKeys.Builder> consumer) {
            Objects.requireNonNull(consumer);
            PemKeys.Builder builder = PemKeys.builder();
            consumer.accept(builder);
            this.pem(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER publicKey(Optional<? extends PublicKey> publicKey) {
            Objects.requireNonNull(publicKey);
            this.publicKey = publicKey.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPublicKey() {
            this.publicKey = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER publicKey(PublicKey publicKey) {
            Objects.requireNonNull(publicKey);
            this.publicKey = publicKey;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER privateKey(Optional<? extends PrivateKey> privateKey) {
            Objects.requireNonNull(privateKey);
            this.privateKey = privateKey.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPrivateKey() {
            this.privateKey = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER privateKey(PrivateKey privateKey) {
            Objects.requireNonNull(privateKey);
            this.privateKey = privateKey;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER publicCert(Optional<? extends X509Certificate> publicCert) {
            Objects.requireNonNull(publicCert);
            this.publicCert = publicCert.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPublicCert() {
            this.publicCert = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER publicCert(X509Certificate publicCert) {
            Objects.requireNonNull(publicCert);
            this.publicCert = publicCert;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certChain(List<? extends X509Certificate> certChain) {
            Objects.requireNonNull(certChain);
            this.certChain.clear();
            this.certChain.addAll(certChain);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCertChain(List<? extends X509Certificate> certChain) {
            Objects.requireNonNull(certChain);
            this.certChain.addAll(certChain);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCertChain(X509Certificate certChain) {
            Objects.requireNonNull(certChain);
            this.certChain.add(certChain);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER certs(List<? extends X509Certificate> certs) {
            Objects.requireNonNull(certs);
            this.certs.clear();
            this.certs.addAll(certs);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCerts(List<? extends X509Certificate> certs) {
            Objects.requireNonNull(certs);
            this.certs.addAll(certs);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCert(X509Certificate cert) {
            Objects.requireNonNull(cert);
            this.certs.add(cert);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public Optional<KeystoreKeys> keystore() {
            return Optional.ofNullable(this.keystore);
        }

        @Override
        public Optional<PemKeys> pem() {
            return Optional.ofNullable(this.pem);
        }

        @Override
        public Optional<PublicKey> publicKey() {
            return Optional.ofNullable(this.publicKey);
        }

        @Override
        public Optional<PrivateKey> privateKey() {
            return Optional.ofNullable(this.privateKey);
        }

        @Override
        public Optional<X509Certificate> publicCert() {
            return Optional.ofNullable(this.publicCert);
        }

        @Override
        public List<X509Certificate> certChain() {
            return this.certChain;
        }

        @Override
        public List<X509Certificate> certs() {
            return this.certs;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "KeysBuilder{keystore=" + String.valueOf(this.keystore) + ",pem=" + String.valueOf(this.pem) + ",publicKey=" + String.valueOf(this.publicKey) + ",privateKey=" + String.valueOf(this.privateKey) + ",publicCert=" + String.valueOf(this.publicCert) + ",certChain=" + String.valueOf(this.certChain) + ",certs=" + String.valueOf(this.certs) + "}";
        }

        protected static class KeysImpl
        implements Keys {
            private final Optional<KeystoreKeys> keystore;
            private final Optional<PemKeys> pem;
            private final Optional<PublicKey> publicKey;
            private final Optional<PrivateKey> privateKey;
            private final Optional<X509Certificate> publicCert;
            private final List<X509Certificate> certChain;
            private final List<X509Certificate> certs;

            protected KeysImpl(BuilderBase<?, ?> builder) {
                this.keystore = builder.keystore();
                this.pem = builder.pem();
                this.publicKey = builder.publicKey();
                this.privateKey = builder.privateKey();
                this.publicCert = builder.publicCert();
                this.certChain = List.copyOf(builder.certChain());
                this.certs = List.copyOf(builder.certs());
            }

            @Override
            public Optional<KeystoreKeys> keystore() {
                return this.keystore;
            }

            @Override
            public Optional<PemKeys> pem() {
                return this.pem;
            }

            @Override
            public Optional<PublicKey> publicKey() {
                return this.publicKey;
            }

            @Override
            public Optional<PrivateKey> privateKey() {
                return this.privateKey;
            }

            @Override
            public Optional<X509Certificate> publicCert() {
                return this.publicCert;
            }

            @Override
            public List<X509Certificate> certChain() {
                return this.certChain;
            }

            @Override
            public List<X509Certificate> certs() {
                return this.certs;
            }

            public String toString() {
                return "Keys{keystore=" + String.valueOf(this.keystore) + ",pem=" + String.valueOf(this.pem) + ",publicKey=" + String.valueOf(this.publicKey) + ",privateKey=" + String.valueOf(this.privateKey) + ",publicCert=" + String.valueOf(this.publicCert) + ",certChain=" + String.valueOf(this.certChain) + ",certs=" + String.valueOf(this.certs) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Keys)) {
                    return false;
                }
                Keys other = (Keys)o;
                return Objects.equals(this.keystore, other.keystore()) && Objects.equals(this.pem, other.pem()) && Objects.equals(this.publicKey, other.publicKey()) && Objects.equals(this.privateKey, other.privateKey()) && Objects.equals(this.publicCert, other.publicCert()) && Objects.equals(this.certChain, other.certChain()) && Objects.equals(this.certs, other.certs());
            }

            public int hashCode() {
                return Objects.hash(this.keystore, this.pem, this.publicKey, this.privateKey, this.publicCert, this.certChain, this.certs);
            }
        }
    }
}

