// This is a generated file (powered by Helidon). Do not edit or extend from this artifact as it is subject to change at any time!
package io.helidon.common.pki;

import io.helidon.common.pki.PemKeysBlueprint;
import io.helidon.builder.api.Prototype.FactoryMethod;
import java.util.Objects;
import io.helidon.common.config.Config;

import java.util.Optional;

/**
 * PEM files based keys - accepts private key and certificate chain.
 * <p>
 * If you have "standard" linux/unix private key, you must run "
 * {@code openssl pkcs8 -topk8 -in ./id_rsa -out ./id_rsa.p8}" on it to work with this builder for password protected
 * file; or "{@code openssl pkcs8 -topk8 -in ./id_rsa -out ./id_rsa_nocrypt.p8 -nocrypt}" for unprotected file.
 * <p>
 * The only supported format is PKCS#8. If you have a different format, you must transform it to PKCS8 PEM format (to
 * use this builder), or to PKCS#12 keystore format (and use {@link io.helidon.common.pki.KeystoreKeys.Builder}).
 *
 * @see #builder()
 * @see #create()
 */
@io.helidon.common.Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.common.pki.PemKeysBlueprint")
public interface PemKeys extends io.helidon.common.pki.PemKeysBlueprint, io.helidon.builder.api.Prototype.Api {
    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static Builder builder() {
        return new PemKeys.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static Builder builder(PemKeys instance) {
        return PemKeys.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static PemKeys create(Config config) {
        return PemKeys.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static PemKeys create() {
         return PemKeys.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link PemKeys}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PemKeys>
            implements io.helidon.builder.api.Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE>,PemKeys {
        private Config config;
        private io.helidon.common.configurable.Resource key;
        private char[] keyPassphrase;
        private io.helidon.common.configurable.Resource publicKey;
        private io.helidon.common.configurable.Resource certChain;
        private io.helidon.common.configurable.Resource certificates;

        /**
         * Protected to support extensibility.
         *
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(PemKeys prototype) {
            key(prototype.key());
            keyPassphrase(prototype.keyPassphrase());
            publicKey(prototype.publicKey());
            certChain(prototype.certChain());
            certificates(prototype.certificates());
            return self();
        }
        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(PemKeys.BuilderBase<?, ?> builder) {
            key(builder.key());
            keyPassphrase(builder.keyPassphrase());
            publicKey(builder.publicKey());
            certChain(builder.certChain());
            certificates(builder.certificates());
            return self();
        }
        /**
         * Handles providers and interceptors.
         */
        protected void preBuildPrototype() {
        }
        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }
        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("key.resource").map(io.helidon.common.configurable.ResourceConfig::create).ifPresent(this::key);
            config.get("key.passphrase").asString().map(String::toCharArray).ifPresent(this::keyPassphrase);
            config.get("public-key.resource").map(io.helidon.common.configurable.ResourceConfig::create).ifPresent(this::publicKey);
            config.get("cert-chain.resource").map(io.helidon.common.configurable.ResourceConfig::create).ifPresent(this::certChain);
            config.get("certificates.resource").map(io.helidon.common.configurable.ResourceConfig::create).ifPresent(this::certificates);
            return self();
        }
        /**
         * Read a private key from PEM format from a resource definition.
         * 
         * @param key key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #key()
         */
        BUILDER key(java.util.Optional<? extends io.helidon.common.configurable.Resource> key) {
            Objects.requireNonNull(key);
            this.key = key.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #key()
         */
        public  BUILDER clearKey() {
            this.key = null;
            return self();
        }
        /**
         * Read a private key from PEM format from a resource definition.
         * 
         * @param key key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #key()
         */
        public BUILDER key(io.helidon.common.configurable.Resource key) {
            Objects.requireNonNull(key);
            key = resolveBuilder(key);
            this.key = key;
            return self();
        }
        /**
         * Read a private key from PEM format from a resource definition.
         * 
         * @param keyConfig key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #key()
         */
        public BUILDER key(io.helidon.common.configurable.ResourceConfig keyConfig) {
            Objects.requireNonNull(keyConfig);
            this.key = io.helidon.common.configurable.Resource.create(keyConfig);
            return self();
        }
        /**
         * Read a private key from PEM format from a resource definition.
         * 
         * @param consumer key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #key()
         */
        public BUILDER key(java.util.function.Consumer<io.helidon.common.configurable.ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = io.helidon.common.configurable.ResourceConfig.builder();
            consumer.accept(builder);
            this.key(builder.build());
            return self();
        }
        /**
         * Passphrase for private key. If the key is encrypted (and in PEM PKCS#8 format), this passphrase will be used to
         * decrypt it.
         * 
         * @param keyPassphrase passphrase used to encrypt the private key
         * @return updated builder instance
         * @see #keyPassphrase()
         */
        BUILDER keyPassphrase(java.util.Optional<? extends char[]> keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #keyPassphrase()
         */
        public  BUILDER clearKeyPassphrase() {
            this.keyPassphrase = null;
            return self();
        }
        /**
         * Passphrase for private key. If the key is encrypted (and in PEM PKCS#8 format), this passphrase will be used to
         * decrypt it.
         * 
         * @param keyPassphrase passphrase used to encrypt the private key
         * @return updated builder instance
         * @see #keyPassphrase()
         */
        public BUILDER keyPassphrase(char[] keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase;
            return self();
        }
        /**
         * Passphrase for private key. If the key is encrypted (and in PEM PKCS#8 format), this passphrase will be used to
         * decrypt it.
         * 
         * @param keyPassphrase passphrase used to encrypt the private key
         * @return updated builder instance
         * @see #keyPassphrase()
         */
        public BUILDER keyPassphrase(java.lang.String keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase.toCharArray();
            return self();
        }
        /**
         * Read a public key from PEM format from a resource definition.
         * 
         * @param publicKey public key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #publicKey()
         */
        BUILDER publicKey(java.util.Optional<? extends io.helidon.common.configurable.Resource> publicKey) {
            Objects.requireNonNull(publicKey);
            this.publicKey = publicKey.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #publicKey()
         */
        public  BUILDER clearPublicKey() {
            this.publicKey = null;
            return self();
        }
        /**
         * Read a public key from PEM format from a resource definition.
         * 
         * @param publicKey public key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #publicKey()
         */
        public BUILDER publicKey(io.helidon.common.configurable.Resource publicKey) {
            Objects.requireNonNull(publicKey);
            publicKey = resolveBuilder(publicKey);
            this.publicKey = publicKey;
            return self();
        }
        /**
         * Read a public key from PEM format from a resource definition.
         * 
         * @param publicKeyConfig public key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #publicKey()
         */
        public BUILDER publicKey(io.helidon.common.configurable.ResourceConfig publicKeyConfig) {
            Objects.requireNonNull(publicKeyConfig);
            this.publicKey = io.helidon.common.configurable.Resource.create(publicKeyConfig);
            return self();
        }
        /**
         * Read a public key from PEM format from a resource definition.
         * 
         * @param consumer public key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #publicKey()
         */
        public BUILDER publicKey(java.util.function.Consumer<io.helidon.common.configurable.ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = io.helidon.common.configurable.ResourceConfig.builder();
            consumer.accept(builder);
            this.publicKey(builder.build());
            return self();
        }
        /**
         * Load certificate chain from PEM resource.
         * 
         * @param certChain resource (e.g. classpath, file path, URL etc.)
         * @return updated builder instance
         * @see #certChain()
         */
        BUILDER certChain(java.util.Optional<? extends io.helidon.common.configurable.Resource> certChain) {
            Objects.requireNonNull(certChain);
            this.certChain = certChain.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #certChain()
         */
        public  BUILDER clearCertChain() {
            this.certChain = null;
            return self();
        }
        /**
         * Load certificate chain from PEM resource.
         * 
         * @param certChain resource (e.g. classpath, file path, URL etc.)
         * @return updated builder instance
         * @see #certChain()
         */
        public BUILDER certChain(io.helidon.common.configurable.Resource certChain) {
            Objects.requireNonNull(certChain);
            certChain = resolveBuilder(certChain);
            this.certChain = certChain;
            return self();
        }
        /**
         * Load certificate chain from PEM resource.
         * 
         * @param certChainConfig resource (e.g. classpath, file path, URL etc.)
         * @return updated builder instance
         * @see #certChain()
         */
        public BUILDER certChain(io.helidon.common.configurable.ResourceConfig certChainConfig) {
            Objects.requireNonNull(certChainConfig);
            this.certChain = io.helidon.common.configurable.Resource.create(certChainConfig);
            return self();
        }
        /**
         * Load certificate chain from PEM resource.
         * 
         * @param consumer resource (e.g. classpath, file path, URL etc.)
         * @return updated builder instance
         * @see #certChain()
         */
        public BUILDER certChain(java.util.function.Consumer<io.helidon.common.configurable.ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = io.helidon.common.configurable.ResourceConfig.builder();
            consumer.accept(builder);
            this.certChain(builder.build());
            return self();
        }
        /**
         * Read one or more certificates in PEM format from a resource definition. Used eg: in a trust store.
         * 
         * @param certificates key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #certificates()
         */
        BUILDER certificates(java.util.Optional<? extends io.helidon.common.configurable.Resource> certificates) {
            Objects.requireNonNull(certificates);
            this.certificates = certificates.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #certificates()
         */
        public  BUILDER clearCertificates() {
            this.certificates = null;
            return self();
        }
        /**
         * Read one or more certificates in PEM format from a resource definition. Used eg: in a trust store.
         * 
         * @param certificates key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #certificates()
         */
        public BUILDER certificates(io.helidon.common.configurable.Resource certificates) {
            Objects.requireNonNull(certificates);
            certificates = resolveBuilder(certificates);
            this.certificates = certificates;
            return self();
        }
        /**
         * Read one or more certificates in PEM format from a resource definition. Used eg: in a trust store.
         * 
         * @param certificatesConfig key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #certificates()
         */
        public BUILDER certificates(io.helidon.common.configurable.ResourceConfig certificatesConfig) {
            Objects.requireNonNull(certificatesConfig);
            this.certificates = io.helidon.common.configurable.Resource.create(certificatesConfig);
            return self();
        }
        /**
         * Read one or more certificates in PEM format from a resource definition. Used eg: in a trust store.
         * 
         * @param consumer key resource (file, classpath, URL etc.)
         * @return updated builder instance
         * @see #certificates()
         */
        public BUILDER certificates(java.util.function.Consumer<io.helidon.common.configurable.ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = io.helidon.common.configurable.ResourceConfig.builder();
            consumer.accept(builder);
            this.certificates(builder.build());
            return self();
        }
        /**
         * Read a private key from PEM format from a resource definition.
         * 
         * @return the key
         */
        @Override
        public java.util.Optional<io.helidon.common.configurable.Resource> key() {
            return Optional.ofNullable(key);
        }
        /**
         * Passphrase for private key. If the key is encrypted (and in PEM PKCS#8 format), this passphrase will be used to
         * decrypt it.
         * 
         * @return the key passphrase
         */
        @Override
        public java.util.Optional<char[]> keyPassphrase() {
            return Optional.ofNullable(keyPassphrase);
        }
        /**
         * Read a public key from PEM format from a resource definition.
         * 
         * @return the public key
         */
        @Override
        public java.util.Optional<io.helidon.common.configurable.Resource> publicKey() {
            return Optional.ofNullable(publicKey);
        }
        /**
         * Load certificate chain from PEM resource.
         * 
         * @return the cert chain
         */
        @Override
        public java.util.Optional<io.helidon.common.configurable.Resource> certChain() {
            return Optional.ofNullable(certChain);
        }
        /**
         * Read one or more certificates in PEM format from a resource definition. Used eg: in a trust store.
         * 
         * @return the certificates
         */
        @Override
        public java.util.Optional<io.helidon.common.configurable.Resource> certificates() {
            return Optional.ofNullable(certificates);
        }
        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }
        @Override
        public String toString() {
            return "PemKeysBuilder{"
                         + "key=" + key + "," 
                         + "keyPassphrase=" + (keyPassphrase == null ? "null" : "****") + "," 
                         + "publicKey=" + publicKey + "," 
                         + "certChain=" + certChain + "," 
                         + "certificates=" + certificates
                        + "}";
        }
        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class PemKeysImpl implements PemKeys{
            private final java.util.Optional<io.helidon.common.configurable.Resource> key;
            private final java.util.Optional<char[]> keyPassphrase;
            private final java.util.Optional<io.helidon.common.configurable.Resource> publicKey;
            private final java.util.Optional<io.helidon.common.configurable.Resource> certChain;
            private final java.util.Optional<io.helidon.common.configurable.Resource> certificates;

            /**
             * Create an instance providing a builder.
             * @param builder extending builder base of this prototype
             */
            protected PemKeysImpl(PemKeys.BuilderBase<?, ?> builder) {
                this.key =  builder.key();
                this.keyPassphrase =  builder.keyPassphrase();
                this.publicKey =  builder.publicKey();
                this.certChain =  builder.certChain();
                this.certificates =  builder.certificates();
            }

    @Override
    public java.util.Optional<io.helidon.common.configurable.Resource> key() {
        return key;
    }

    @Override
    public java.util.Optional<char[]> keyPassphrase() {
        return keyPassphrase;
    }

    @Override
    public java.util.Optional<io.helidon.common.configurable.Resource> publicKey() {
        return publicKey;
    }

    @Override
    public java.util.Optional<io.helidon.common.configurable.Resource> certChain() {
        return certChain;
    }

    @Override
    public java.util.Optional<io.helidon.common.configurable.Resource> certificates() {
        return certificates;
    }
        @Override
        public String toString() {
            return "PemKeys{"
                         + "key=" + key + "," 
                         + "keyPassphrase=" + (keyPassphrase.isPresent() ? "****" : "null") + "," 
                         + "publicKey=" + publicKey + "," 
                         + "certChain=" + certChain + "," 
                         + "certificates=" + certificates
                        + "}";
        }
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PemKeys other)) {
                return false;
            }
            return Objects.equals(key, other.key()) && Objects.equals(keyPassphrase, other.keyPassphrase()) && Objects.equals(publicKey, other.publicKey()) && Objects.equals(certChain, other.certChain()) && Objects.equals(certificates, other.certificates());
        }
        @Override
        public int hashCode() {
            return Objects.hash(key, keyPassphrase, publicKey, certChain, certificates);
        }
        }
    }
    /**
     * Fluent API builder for {@link PemKeys}.
     */
    class Builder extends BuilderBase<Builder, PemKeys> implements io.helidon.common.Builder<Builder, PemKeys> {
        private Builder() {
        }
        @Override
        public PemKeys buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new PemKeysImpl(this);
        }

        @Override
        public PemKeys build() {
            return buildPrototype();
        }

    }
}
