// This is a generated file (powered by Helidon). Do not edit or extend from this artifact as it is subject to change at any time!
package io.helidon.common.pki;

import io.helidon.common.pki.KeystoreKeysBlueprint;
import io.helidon.builder.api.Prototype.FactoryMethod;
import java.util.Objects;
import io.helidon.common.Errors;
import io.helidon.common.config.Config;

import java.util.Optional;

/**
 * Resources from a java keystore (PKCS12, JKS etc.).
 *
 * @see #builder()
 */
@io.helidon.common.Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.common.pki.KeystoreKeysBlueprint")
public interface KeystoreKeys extends io.helidon.common.pki.KeystoreKeysBlueprint, io.helidon.builder.api.Prototype.Api {
    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static Builder builder() {
        return new KeystoreKeys.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static Builder builder(KeystoreKeys instance) {
        return KeystoreKeys.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static KeystoreKeys create(Config config) {
        return KeystoreKeys.builder().config(config).buildPrototype();
    }

    /**
     * Fluent API builder base for {@link KeystoreKeys}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends KeystoreKeys>
            implements io.helidon.builder.api.Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE>,KeystoreKeys {
        private Config config;
        private io.helidon.common.configurable.Resource keystore;
        private java.lang.String type = "PKCS12";
        private char[] passphrase;
        private java.lang.String keyAlias;
        private char[] keyPassphrase;
        private java.lang.String certAlias;
        private java.lang.String certChainAlias;
        private final java.util.List<java.lang.String> certAliases = new java.util.ArrayList<>();
        private boolean trustStore = false;

        /**
         * Protected to support extensibility.
         *
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(KeystoreKeys prototype) {
            keystore(prototype.keystore());
            type(prototype.type());
            passphrase(prototype.passphrase());
            keyAlias(prototype.keyAlias());
            keyPassphrase(prototype.keyPassphrase());
            certAlias(prototype.certAlias());
            certChainAlias(prototype.certChainAlias());
            addCertAliases(prototype.certAliases());
            trustStore(prototype.trustStore());
            return self();
        }
        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(KeystoreKeys.BuilderBase<?, ?> builder) {
            if (builder.keystore() != null) {
                keystore(builder.keystore());
            }
            if (builder.type() != null) {
                type(builder.type());
            }
            passphrase(builder.passphrase());
            keyAlias(builder.keyAlias());
            keyPassphrase(builder.keyPassphrase());
            certAlias(builder.certAlias());
            certChainAlias(builder.certChainAlias());
            addCertAliases(builder.certAliases());
            trustStore(builder.trustStore());
            return self();
        }
        /**
         * Handles providers and interceptors.
         */
        protected void preBuildPrototype() {
        }
        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        Errors.Collector collector = Errors.collector();
        if (keystore == null) {
            collector.fatal(getClass(), "Property \"resource\" is required, but not set");
        }
        collector.collect().checkValid();
        }
    /**
     *Keystore passphrase.
     *
     *@param passphrase new keystore passphrase
     *@return updated builder instance
     *@deprecated use {@link #passphrase(String)} instead
     */
    public BUILDER keystorePassphrase(java.lang.String passphrase) {
        io.helidon.common.pki.KeystoreKeysBlueprint.CustomMethods.keystorePassphrase(this, passphrase);  return self();
    }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("resource").map(io.helidon.common.configurable.ResourceConfig::create).ifPresent(this::keystore);
            config.get("type").as(java.lang.String.class).ifPresent(this::type);
            config.get("passphrase").asString().map(String::toCharArray).ifPresent(this::passphrase);
            config.get("key.alias").as(java.lang.String.class).ifPresent(this::keyAlias);
            config.get("key.passphrase").asString().map(String::toCharArray).ifPresent(this::keyPassphrase);
            config.get("cert.alias").as(java.lang.String.class).ifPresent(this::certAlias);
            config.get("cert-chain.alias").as(java.lang.String.class).ifPresent(this::certChainAlias);
            config.get("trust-store").as(java.lang.Boolean.class).ifPresent(this::trustStore);
            return self();
        }
        /**
         * Keystore resource definition.
         * 
         * @param keystore keystore resource, from file path, classpath, URL etc.
         * @return updated builder instance
         * @see #keystore()
         */
        public BUILDER keystore(io.helidon.common.configurable.Resource keystore) {
            Objects.requireNonNull(keystore);
            keystore = resolveBuilder(keystore);
            this.keystore = keystore;
            return self();
        }
        /**
         * Keystore resource definition.
         * 
         * @param keystoreConfig keystore resource, from file path, classpath, URL etc.
         * @return updated builder instance
         * @see #keystore()
         */
        public BUILDER keystore(io.helidon.common.configurable.ResourceConfig keystoreConfig) {
            Objects.requireNonNull(keystoreConfig);
            this.keystore = io.helidon.common.configurable.Resource.create(keystoreConfig);
            return self();
        }
        /**
         * Keystore resource definition.
         * 
         * @param consumer consumer of builder for
         * keystore resource, from file path, classpath, URL etc.
         * @return updated builder instance
         * @see #keystore()
         */
        public BUILDER keystore(java.util.function.Consumer<io.helidon.common.configurable.ResourceConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = io.helidon.common.configurable.ResourceConfig.builder();
            consumer.accept(builder);
            this.keystore(builder.build());
            return self();
        }
        /**
         * Set type of keystore.
         * Defaults to {@value #DEFAULT_KEYSTORE_TYPE},
         * expected are other keystore types supported by java then can store keys under aliases.
         * 
         * @param type keystore type to load the key
         * @return updated builder instance
         * @see #type()
         */
        public BUILDER type(java.lang.String type) {
            Objects.requireNonNull(type);
            this.type = type;
            return self();
        }
        /**
         * Pass-phrase of the keystore (supported with JKS and PKCS12 keystores).
         * 
         * @param passphrase keystore password to use
         * @return updated builder instance
         * @see #passphrase()
         */
        BUILDER passphrase(java.util.Optional<? extends char[]> passphrase) {
            Objects.requireNonNull(passphrase);
            this.passphrase = passphrase.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #passphrase()
         */
        public  BUILDER clearPassphrase() {
            this.passphrase = null;
            return self();
        }
        /**
         * Pass-phrase of the keystore (supported with JKS and PKCS12 keystores).
         * 
         * @param passphrase keystore password to use
         * @return updated builder instance
         * @see #passphrase()
         */
        public BUILDER passphrase(char[] passphrase) {
            Objects.requireNonNull(passphrase);
            this.passphrase = passphrase;
            return self();
        }
        /**
         * Pass-phrase of the keystore (supported with JKS and PKCS12 keystores).
         * 
         * @param passphrase keystore password to use
         * @return updated builder instance
         * @see #passphrase()
         */
        public BUILDER passphrase(java.lang.String passphrase) {
            Objects.requireNonNull(passphrase);
            this.passphrase = passphrase.toCharArray();
            return self();
        }
        /**
         * Alias of the private key in the keystore.
         * 
         * @param keyAlias alias of the key in the keystore
         * @return updated builder instance
         * @see #keyAlias()
         */
        BUILDER keyAlias(java.util.Optional<? extends java.lang.String> keyAlias) {
            Objects.requireNonNull(keyAlias);
            this.keyAlias = keyAlias.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #keyAlias()
         */
        public  BUILDER clearKeyAlias() {
            this.keyAlias = null;
            return self();
        }
        /**
         * Alias of the private key in the keystore.
         * 
         * @param keyAlias alias of the key in the keystore
         * @return updated builder instance
         * @see #keyAlias()
         */
        public BUILDER keyAlias(java.lang.String keyAlias) {
            Objects.requireNonNull(keyAlias);
            this.keyAlias = keyAlias;
            return self();
        }
        /**
         * Pass-phrase of the key in the keystore (used for private keys).
         * This is (by default) the same as keystore passphrase - only configure
         * if it differs from keystore passphrase.
         * 
         * @param keyPassphrase pass-phrase of the key
         * @return updated builder instance
         * @see #keyPassphrase()
         */
        BUILDER keyPassphrase(java.util.Optional<? extends char[]> keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #keyPassphrase()
         */
        public  BUILDER clearKeyPassphrase() {
            this.keyPassphrase = null;
            return self();
        }
        /**
         * Pass-phrase of the key in the keystore (used for private keys).
         * This is (by default) the same as keystore passphrase - only configure
         * if it differs from keystore passphrase.
         * 
         * @param keyPassphrase pass-phrase of the key
         * @return updated builder instance
         * @see #keyPassphrase()
         */
        public BUILDER keyPassphrase(char[] keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase;
            return self();
        }
        /**
         * Pass-phrase of the key in the keystore (used for private keys).
         * This is (by default) the same as keystore passphrase - only configure
         * if it differs from keystore passphrase.
         * 
         * @param keyPassphrase pass-phrase of the key
         * @return updated builder instance
         * @see #keyPassphrase()
         */
        public BUILDER keyPassphrase(java.lang.String keyPassphrase) {
            Objects.requireNonNull(keyPassphrase);
            this.keyPassphrase = keyPassphrase.toCharArray();
            return self();
        }
        /**
         * Alias of X.509 certificate of public key.
         * Used to load both the certificate and public key.
         * 
         * @param certAlias alias under which the certificate is stored in the keystore
         * @return updated builder instance
         * @see #certAlias()
         */
        BUILDER certAlias(java.util.Optional<? extends java.lang.String> certAlias) {
            Objects.requireNonNull(certAlias);
            this.certAlias = certAlias.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #certAlias()
         */
        public  BUILDER clearCertAlias() {
            this.certAlias = null;
            return self();
        }
        /**
         * Alias of X.509 certificate of public key.
         * Used to load both the certificate and public key.
         * 
         * @param certAlias alias under which the certificate is stored in the keystore
         * @return updated builder instance
         * @see #certAlias()
         */
        public BUILDER certAlias(java.lang.String certAlias) {
            Objects.requireNonNull(certAlias);
            this.certAlias = certAlias;
            return self();
        }
        /**
         * Alias of an X.509 chain.
         * 
         * @param certChainAlias alias of certificate chain in the keystore
         * @return updated builder instance
         * @see #certChainAlias()
         */
        BUILDER certChainAlias(java.util.Optional<? extends java.lang.String> certChainAlias) {
            Objects.requireNonNull(certChainAlias);
            this.certChainAlias = certChainAlias.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #certChainAlias()
         */
        public  BUILDER clearCertChainAlias() {
            this.certChainAlias = null;
            return self();
        }
        /**
         * Alias of an X.509 chain.
         * 
         * @param certChainAlias alias of certificate chain in the keystore
         * @return updated builder instance
         * @see #certChainAlias()
         */
        public BUILDER certChainAlias(java.lang.String certChainAlias) {
            Objects.requireNonNull(certChainAlias);
            this.certChainAlias = certChainAlias;
            return self();
        }
        /**
         * List of aliases used to generate a trusted set of certificates.
         * 
         * @param certAliases aliases of certificates
         * @return updated builder instance
         * @see #certAliases()
         */
        public BUILDER certAliases(java.util.List<? extends java.lang.String> certAliases) {
            Objects.requireNonNull(certAliases);
            this.certAliases.clear();
            this.certAliases.addAll(certAliases);
            return self();
        }
        /**
         * List of aliases used to generate a trusted set of certificates.
         * 
         * @param certAliases aliases of certificates
         * @return updated builder instance
         * @see #certAliases()
         */
        public BUILDER addCertAliases(java.util.List<? extends java.lang.String> certAliases) {
            Objects.requireNonNull(certAliases);
            this.certAliases.addAll(certAliases);
            return self();
        }
        /**
         * List of aliases used to generate a trusted set of certificates.
         * 
         * @param certAlias aliases of certificates
         * @return updated builder instance
         * @see #certAliases()
         */
        public BUILDER addCertAlias(java.lang.String certAlias) {
            Objects.requireNonNull(certAlias);
            this.certAliases.add(certAlias);
            return self();
        }
        /**
         * If you want to build a trust store, call this method to add all
         * certificates present in the keystore to certificate list.
         * 
         * @param trustStore whether this is a trust store
         * @return updated builder instance
         * @see #trustStore()
         */
        public BUILDER trustStore(boolean trustStore) {
            this.trustStore = trustStore;
            return self();
        }
        /**
         * Keystore resource definition.
         * 
         * @return the keystore
         */
        @Override
        public io.helidon.common.configurable.Resource keystore() {
            return keystore;
        }
        /**
         * Set type of keystore.
         * Defaults to {@value #DEFAULT_KEYSTORE_TYPE},
         * expected are other keystore types supported by java then can store keys under aliases.
         * 
         * @return the type
         */
        @Override
        public java.lang.String type() {
            return type;
        }
        /**
         * Pass-phrase of the keystore (supported with JKS and PKCS12 keystores).
         * 
         * @return the passphrase
         */
        @Override
        public java.util.Optional<char[]> passphrase() {
            return Optional.ofNullable(passphrase);
        }
        /**
         * Alias of the private key in the keystore.
         * 
         * @return the key alias
         */
        @Override
        public java.util.Optional<java.lang.String> keyAlias() {
            return Optional.ofNullable(keyAlias);
        }
        /**
         * Pass-phrase of the key in the keystore (used for private keys).
         * This is (by default) the same as keystore passphrase - only configure
         * if it differs from keystore passphrase.
         * 
         * @return the key passphrase
         */
        @Override
        public java.util.Optional<char[]> keyPassphrase() {
            return Optional.ofNullable(keyPassphrase);
        }
        /**
         * Alias of X.509 certificate of public key.
         * Used to load both the certificate and public key.
         * 
         * @return the cert alias
         */
        @Override
        public java.util.Optional<java.lang.String> certAlias() {
            return Optional.ofNullable(certAlias);
        }
        /**
         * Alias of an X.509 chain.
         * 
         * @return the cert chain alias
         */
        @Override
        public java.util.Optional<java.lang.String> certChainAlias() {
            return Optional.ofNullable(certChainAlias);
        }
        /**
         * List of aliases used to generate a trusted set of certificates.
         * 
         * @return the cert aliases
         */
        @Override
        public java.util.List<java.lang.String> certAliases() {
            return certAliases;
        }
        /**
         * If you want to build a trust store, call this method to add all
         * certificates present in the keystore to certificate list.
         * 
         * @return the trust store
         */
        @Override
        public boolean trustStore() {
            return trustStore;
        }
        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }
        @Override
        public String toString() {
            return "KeystoreKeysBuilder{"
                         + "keystore=" + keystore + "," 
                         + "type=" + type + "," 
                         + "passphrase=" + (passphrase == null ? "null" : "****") + "," 
                         + "keyAlias=" + keyAlias + "," 
                         + "keyPassphrase=" + (keyPassphrase == null ? "null" : "****") + "," 
                         + "certAlias=" + certAlias + "," 
                         + "certChainAlias=" + certChainAlias + "," 
                         + "certAliases=" + certAliases + "," 
                         + "trustStore=" + trustStore
                        + "}";
        }
        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class KeystoreKeysImpl implements KeystoreKeys{
            private final io.helidon.common.configurable.Resource keystore;
            private final java.lang.String type;
            private final java.util.Optional<char[]> passphrase;
            private final java.util.Optional<java.lang.String> keyAlias;
            private final java.util.Optional<char[]> keyPassphrase;
            private final java.util.Optional<java.lang.String> certAlias;
            private final java.util.Optional<java.lang.String> certChainAlias;
            private final java.util.List<java.lang.String> certAliases;
            private final boolean trustStore;

            /**
             * Create an instance providing a builder.
             * @param builder extending builder base of this prototype
             */
            protected KeystoreKeysImpl(KeystoreKeys.BuilderBase<?, ?> builder) {
                this.keystore =  builder.keystore();
                this.type =  builder.type();
                this.passphrase =  builder.passphrase();
                this.keyAlias =  builder.keyAlias();
                this.keyPassphrase =  builder.keyPassphrase();
                this.certAlias =  builder.certAlias();
                this.certChainAlias =  builder.certChainAlias();
                this.certAliases = java.util.List.copyOf(builder.certAliases());
                this.trustStore =  builder.trustStore();
            }

    @Override
    public io.helidon.common.configurable.Resource keystore() {
        return keystore;
    }

    @Override
    public java.lang.String type() {
        return type;
    }

    @Override
    public java.util.Optional<char[]> passphrase() {
        return passphrase;
    }

    @Override
    public java.util.Optional<java.lang.String> keyAlias() {
        return keyAlias;
    }

    @Override
    public java.util.Optional<char[]> keyPassphrase() {
        return keyPassphrase;
    }

    @Override
    public java.util.Optional<java.lang.String> certAlias() {
        return certAlias;
    }

    @Override
    public java.util.Optional<java.lang.String> certChainAlias() {
        return certChainAlias;
    }

    @Override
    public java.util.List<java.lang.String> certAliases() {
        return certAliases;
    }

    @Override
    public boolean trustStore() {
        return trustStore;
    }
        @Override
        public String toString() {
            return "KeystoreKeys{"
                         + "keystore=" + keystore + "," 
                         + "type=" + type + "," 
                         + "passphrase=" + (passphrase.isPresent() ? "****" : "null") + "," 
                         + "keyAlias=" + keyAlias + "," 
                         + "keyPassphrase=" + (keyPassphrase.isPresent() ? "****" : "null") + "," 
                         + "certAlias=" + certAlias + "," 
                         + "certChainAlias=" + certChainAlias + "," 
                         + "certAliases=" + certAliases + "," 
                         + "trustStore=" + trustStore
                        + "}";
        }
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeystoreKeys other)) {
                return false;
            }
            return Objects.equals(keystore, other.keystore()) && Objects.equals(type, other.type()) && Objects.equals(passphrase, other.passphrase()) && Objects.equals(keyAlias, other.keyAlias()) && Objects.equals(keyPassphrase, other.keyPassphrase()) && Objects.equals(certAlias, other.certAlias()) && Objects.equals(certChainAlias, other.certChainAlias()) && Objects.equals(certAliases, other.certAliases()) && trustStore == other.trustStore();
        }
        @Override
        public int hashCode() {
            return Objects.hash(keystore, type, passphrase, keyAlias, keyPassphrase, certAlias, certChainAlias, certAliases, trustStore);
        }
        }
    }
    /**
     * Fluent API builder for {@link KeystoreKeys}.
     */
    class Builder extends BuilderBase<Builder, KeystoreKeys> implements io.helidon.common.Builder<Builder, KeystoreKeys> {
        private Builder() {
        }
        @Override
        public KeystoreKeys buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new KeystoreKeysImpl(this);
        }

        @Override
        public KeystoreKeys build() {
            return buildPrototype();
        }

    }
}
