// This is a generated file (powered by Helidon). Do not edit or extend from this artifact as it is subject to change at any time!
package io.helidon.common.pki;

import io.helidon.common.pki.KeysBlueprint;
import io.helidon.builder.api.Prototype.FactoryMethod;
import java.util.Objects;
import io.helidon.common.config.Config;

import java.util.Optional;

/**
 * Configuration of keys. If a key is defined in multiple places (keystore, pem, or explicit), the order of preference is:
 * <ul>
 *     <li>Explicit instance will be used</li>
 *     <li>Keystore will be used</li>
 *     <li>PEM will be used</li>
 * </ul>
 * So if a Private key is defined both explicitly and through PEM, the explicitly defined key would be used.
 *
 * @see #builder()
 * @see #create()
 */
@io.helidon.common.Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.common.pki.KeysBlueprint")
public interface Keys extends io.helidon.common.pki.KeysBlueprint, io.helidon.builder.api.Prototype.Api {
    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static Builder builder() {
        return new Keys.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static Builder builder(Keys instance) {
        return Keys.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static Keys create(Config config) {
        return Keys.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static Keys create() {
         return Keys.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link Keys}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Keys>
            implements io.helidon.builder.api.Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE>,Keys {
        private Config config;
        private KeystoreKeys keystore;
        private PemKeys pem;
        private java.security.PublicKey publicKey;
        private java.security.PrivateKey privateKey;
        private java.security.cert.X509Certificate publicCert;
        private final java.util.List<java.security.cert.X509Certificate> certChain = new java.util.ArrayList<>();
        private final java.util.List<java.security.cert.X509Certificate> certs = new java.util.ArrayList<>();

        /**
         * Protected to support extensibility.
         *
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(Keys prototype) {
            keystore(prototype.keystore());
            pem(prototype.pem());
            publicKey(prototype.publicKey());
            privateKey(prototype.privateKey());
            publicCert(prototype.publicCert());
            addCertChain(prototype.certChain());
            addCerts(prototype.certs());
            return self();
        }
        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(Keys.BuilderBase<?, ?> builder) {
            keystore(builder.keystore());
            pem(builder.pem());
            publicKey(builder.publicKey());
            privateKey(builder.privateKey());
            publicCert(builder.publicCert());
            addCertChain(builder.certChain());
            addCerts(builder.certs());
            return self();
        }
        /**
         * Handles providers and interceptors.
         */
        protected void preBuildPrototype() {
            new io.helidon.common.pki.KeysBuilderInterceptor().intercept(this);

        }
        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }
        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("keystore").map(KeystoreKeys::create).ifPresent(this::keystore);
            config.get("pem").map(PemKeys::create).ifPresent(this::pem);
            return self();
        }
        /**
         * Configure keys from a keystore.
         * Once the config object is built, this option will ALWAYS be empty. All keys from the keystore will be
         * populated to {@link #privateKey()}, {@link #publicKey()}, {@link #publicCert()} etc.
         * 
         * @param keystore keystore configuration
         * @return updated builder instance
         * @see #keystore()
         */
        BUILDER keystore(java.util.Optional<? extends KeystoreKeys> keystore) {
            Objects.requireNonNull(keystore);
            this.keystore = keystore.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #keystore()
         */
        public  BUILDER clearKeystore() {
            this.keystore = null;
            return self();
        }
        /**
         * Configure keys from a keystore.
         * Once the config object is built, this option will ALWAYS be empty. All keys from the keystore will be
         * populated to {@link #privateKey()}, {@link #publicKey()}, {@link #publicCert()} etc.
         * 
         * @param keystore keystore configuration
         * @return updated builder instance
         * @see #keystore()
         */
        public BUILDER keystore(KeystoreKeys keystore) {
            Objects.requireNonNull(keystore);
            keystore = resolveBuilder(keystore);
            this.keystore = keystore;
            return self();
        }
        /**
         * Configure keys from a keystore.
         * Once the config object is built, this option will ALWAYS be empty. All keys from the keystore will be
         * populated to {@link #privateKey()}, {@link #publicKey()}, {@link #publicCert()} etc.
         * 
         * @param consumer keystore configuration
         * @return updated builder instance
         * @see #keystore()
         */
        public BUILDER keystore(java.util.function.Consumer<KeystoreKeys.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = KeystoreKeys.builder();
            consumer.accept(builder);
            this.keystore(builder.build());
            return self();
        }
        /**
         * Configure keys from pem file(s).
         * Once the config object is built, this option will ALWAYS be empty. All keys from the keystore will be
         * populated to {@link #privateKey()}, {@link #publicKey()}, {@link #publicCert()} etc.
         * 
         * @param pem pem based definition
         * @return updated builder instance
         * @see #pem()
         */
        BUILDER pem(java.util.Optional<? extends PemKeys> pem) {
            Objects.requireNonNull(pem);
            this.pem = pem.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #pem()
         */
        public  BUILDER clearPem() {
            this.pem = null;
            return self();
        }
        /**
         * Configure keys from pem file(s).
         * Once the config object is built, this option will ALWAYS be empty. All keys from the keystore will be
         * populated to {@link #privateKey()}, {@link #publicKey()}, {@link #publicCert()} etc.
         * 
         * @param pem pem based definition
         * @return updated builder instance
         * @see #pem()
         */
        public BUILDER pem(PemKeys pem) {
            Objects.requireNonNull(pem);
            pem = resolveBuilder(pem);
            this.pem = pem;
            return self();
        }
        /**
         * Configure keys from pem file(s).
         * Once the config object is built, this option will ALWAYS be empty. All keys from the keystore will be
         * populated to {@link #privateKey()}, {@link #publicKey()}, {@link #publicCert()} etc.
         * 
         * @param consumer pem based definition
         * @return updated builder instance
         * @see #pem()
         */
        public BUILDER pem(java.util.function.Consumer<PemKeys.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = PemKeys.builder();
            consumer.accept(builder);
            this.pem(builder.build());
            return self();
        }
        /**
         * The public key of this config if configured.
         * 
         * @param publicKey the public key of this config or empty if not configured
         * @return updated builder instance
         * @see #publicKey()
         */
        BUILDER publicKey(java.util.Optional<? extends java.security.PublicKey> publicKey) {
            Objects.requireNonNull(publicKey);
            this.publicKey = publicKey.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #publicKey()
         */
        public  BUILDER clearPublicKey() {
            this.publicKey = null;
            return self();
        }
        /**
         * The public key of this config if configured.
         * 
         * @param publicKey the public key of this config or empty if not configured
         * @return updated builder instance
         * @see #publicKey()
         */
        public BUILDER publicKey(java.security.PublicKey publicKey) {
            Objects.requireNonNull(publicKey);
            this.publicKey = publicKey;
            return self();
        }
        /**
         * The private key of this config if configured.
         * 
         * @param privateKey the private key of this config or empty if not configured
         * @return updated builder instance
         * @see #privateKey()
         */
        BUILDER privateKey(java.util.Optional<? extends java.security.PrivateKey> privateKey) {
            Objects.requireNonNull(privateKey);
            this.privateKey = privateKey.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #privateKey()
         */
        public  BUILDER clearPrivateKey() {
            this.privateKey = null;
            return self();
        }
        /**
         * The private key of this config if configured.
         * 
         * @param privateKey the private key of this config or empty if not configured
         * @return updated builder instance
         * @see #privateKey()
         */
        public BUILDER privateKey(java.security.PrivateKey privateKey) {
            Objects.requireNonNull(privateKey);
            this.privateKey = privateKey;
            return self();
        }
        /**
         * The public X.509 Certificate if configured.
         * 
         * @param publicCert the public certificate of this config or empty if not configured
         * @return updated builder instance
         * @see #publicCert()
         */
        BUILDER publicCert(java.util.Optional<? extends java.security.cert.X509Certificate> publicCert) {
            Objects.requireNonNull(publicCert);
            this.publicCert = publicCert.orElse(null);
            return self();
        }
        /**
         * Clear existing value of this property.
         * @return updated builder instance
         * @see #publicCert()
         */
        public  BUILDER clearPublicCert() {
            this.publicCert = null;
            return self();
        }
        /**
         * The public X.509 Certificate if configured.
         * 
         * @param publicCert the public certificate of this config or empty if not configured
         * @return updated builder instance
         * @see #publicCert()
         */
        public BUILDER publicCert(java.security.cert.X509Certificate publicCert) {
            Objects.requireNonNull(publicCert);
            this.publicCert = publicCert;
            return self();
        }
        /**
         * The X.509 Certificate Chain.
         * 
         * @param certChain the certificate chain or empty list if not configured
         * @return updated builder instance
         * @see #certChain()
         */
        public BUILDER certChain(java.util.List<? extends java.security.cert.X509Certificate> certChain) {
            Objects.requireNonNull(certChain);
            this.certChain.clear();
            this.certChain.addAll(certChain);
            return self();
        }
        /**
         * The X.509 Certificate Chain.
         * 
         * @param certChain the certificate chain or empty list if not configured
         * @return updated builder instance
         * @see #certChain()
         */
        public BUILDER addCertChain(java.util.List<? extends java.security.cert.X509Certificate> certChain) {
            Objects.requireNonNull(certChain);
            this.certChain.addAll(certChain);
            return self();
        }
        /**
         * The X.509 Certificate Chain.
         * 
         * @param certChain the certificate chain or empty list if not configured
         * @return updated builder instance
         * @see #certChain()
         */
        public BUILDER addCertChain(java.security.cert.X509Certificate certChain) {
            Objects.requireNonNull(certChain);
            this.certChain.add(certChain);
            return self();
        }
        /**
         * The X.509 Certificates.
         * 
         * @param certs the certificates configured or empty list if none configured
         * @return updated builder instance
         * @see #certs()
         */
        public BUILDER certs(java.util.List<? extends java.security.cert.X509Certificate> certs) {
            Objects.requireNonNull(certs);
            this.certs.clear();
            this.certs.addAll(certs);
            return self();
        }
        /**
         * The X.509 Certificates.
         * 
         * @param certs the certificates configured or empty list if none configured
         * @return updated builder instance
         * @see #certs()
         */
        public BUILDER addCerts(java.util.List<? extends java.security.cert.X509Certificate> certs) {
            Objects.requireNonNull(certs);
            this.certs.addAll(certs);
            return self();
        }
        /**
         * The X.509 Certificates.
         * 
         * @param cert the certificates configured or empty list if none configured
         * @return updated builder instance
         * @see #certs()
         */
        public BUILDER addCert(java.security.cert.X509Certificate cert) {
            Objects.requireNonNull(cert);
            this.certs.add(cert);
            return self();
        }
        /**
         * Configure keys from a keystore.
         * Once the config object is built, this option will ALWAYS be empty. All keys from the keystore will be
         * populated to {@link #privateKey()}, {@link #publicKey()}, {@link #publicCert()} etc.
         * 
         * @return the keystore
         */
        @Override
        public java.util.Optional<KeystoreKeys> keystore() {
            return Optional.ofNullable(keystore);
        }
        /**
         * Configure keys from pem file(s).
         * Once the config object is built, this option will ALWAYS be empty. All keys from the keystore will be
         * populated to {@link #privateKey()}, {@link #publicKey()}, {@link #publicCert()} etc.
         * 
         * @return the pem
         */
        @Override
        public java.util.Optional<PemKeys> pem() {
            return Optional.ofNullable(pem);
        }
        /**
         * The public key of this config if configured.
         * 
         * @return the public key
         */
        @Override
        public java.util.Optional<java.security.PublicKey> publicKey() {
            return Optional.ofNullable(publicKey);
        }
        /**
         * The private key of this config if configured.
         * 
         * @return the private key
         */
        @Override
        public java.util.Optional<java.security.PrivateKey> privateKey() {
            return Optional.ofNullable(privateKey);
        }
        /**
         * The public X.509 Certificate if configured.
         * 
         * @return the public cert
         */
        @Override
        public java.util.Optional<java.security.cert.X509Certificate> publicCert() {
            return Optional.ofNullable(publicCert);
        }
        /**
         * The X.509 Certificate Chain.
         * 
         * @return the cert chain
         */
        @Override
        public java.util.List<java.security.cert.X509Certificate> certChain() {
            return certChain;
        }
        /**
         * The X.509 Certificates.
         * 
         * @return the certs
         */
        @Override
        public java.util.List<java.security.cert.X509Certificate> certs() {
            return certs;
        }
        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }
        @Override
        public String toString() {
            return "KeysBuilder{"
                         + "keystore=" + keystore + "," 
                         + "pem=" + pem + "," 
                         + "publicKey=" + publicKey + "," 
                         + "privateKey=" + privateKey + "," 
                         + "publicCert=" + publicCert + "," 
                         + "certChain=" + certChain + "," 
                         + "certs=" + certs
                        + "}";
        }
        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class KeysImpl implements Keys{
            private final java.util.Optional<KeystoreKeys> keystore;
            private final java.util.Optional<PemKeys> pem;
            private final java.util.Optional<java.security.PublicKey> publicKey;
            private final java.util.Optional<java.security.PrivateKey> privateKey;
            private final java.util.Optional<java.security.cert.X509Certificate> publicCert;
            private final java.util.List<java.security.cert.X509Certificate> certChain;
            private final java.util.List<java.security.cert.X509Certificate> certs;

            /**
             * Create an instance providing a builder.
             * @param builder extending builder base of this prototype
             */
            protected KeysImpl(Keys.BuilderBase<?, ?> builder) {
                this.keystore =  builder.keystore();
                this.pem =  builder.pem();
                this.publicKey =  builder.publicKey();
                this.privateKey =  builder.privateKey();
                this.publicCert =  builder.publicCert();
                this.certChain = java.util.List.copyOf(builder.certChain());
                this.certs = java.util.List.copyOf(builder.certs());
            }

    @Override
    public java.util.Optional<KeystoreKeys> keystore() {
        return keystore;
    }

    @Override
    public java.util.Optional<PemKeys> pem() {
        return pem;
    }

    @Override
    public java.util.Optional<java.security.PublicKey> publicKey() {
        return publicKey;
    }

    @Override
    public java.util.Optional<java.security.PrivateKey> privateKey() {
        return privateKey;
    }

    @Override
    public java.util.Optional<java.security.cert.X509Certificate> publicCert() {
        return publicCert;
    }

    @Override
    public java.util.List<java.security.cert.X509Certificate> certChain() {
        return certChain;
    }

    @Override
    public java.util.List<java.security.cert.X509Certificate> certs() {
        return certs;
    }
        @Override
        public String toString() {
            return "Keys{"
                         + "keystore=" + keystore + "," 
                         + "pem=" + pem + "," 
                         + "publicKey=" + publicKey + "," 
                         + "privateKey=" + privateKey + "," 
                         + "publicCert=" + publicCert + "," 
                         + "certChain=" + certChain + "," 
                         + "certs=" + certs
                        + "}";
        }
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Keys other)) {
                return false;
            }
            return Objects.equals(keystore, other.keystore()) && Objects.equals(pem, other.pem()) && Objects.equals(publicKey, other.publicKey()) && Objects.equals(privateKey, other.privateKey()) && Objects.equals(publicCert, other.publicCert()) && Objects.equals(certChain, other.certChain()) && Objects.equals(certs, other.certs());
        }
        @Override
        public int hashCode() {
            return Objects.hash(keystore, pem, publicKey, privateKey, publicCert, certChain, certs);
        }
        }
    }
    /**
     * Fluent API builder for {@link Keys}.
     */
    class Builder extends BuilderBase<Builder, Keys> implements io.helidon.common.Builder<Builder, Keys> {
        private Builder() {
        }
        @Override
        public Keys buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new KeysImpl(this);
        }

        @Override
        public Keys build() {
            return buildPrototype();
        }

    }
}
