/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.config.Config;
import io.helidon.common.configurable.AllowList;
import io.helidon.common.http.Forwarded;
import io.helidon.common.http.Http;
import io.helidon.common.http.ServerRequestHeaders;
import io.helidon.common.uri.UriInfo;
import io.helidon.common.uri.UriQuery;
import io.helidon.config.metadata.Configured;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public interface RequestedUriDiscoveryContext {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Config config) {
        return RequestedUriDiscoveryContext.builder().config(config);
    }

    public static RequestedUriDiscoveryContext create(Config config) {
        return RequestedUriDiscoveryContext.builder().config(config).build();
    }

    public UriInfo uriInfo(String var1, String var2, String var3, ServerRequestHeaders var4, UriQuery var5, boolean var6);

    @Configured
    public static final class Builder
    implements io.helidon.common.Builder<Builder, RequestedUriDiscoveryContext> {
        public static final String REQUESTED_URI_DISCOVERY_CONFIG_KEY = "requested-uri-discovery";
        private static final System.Logger LOGGER = System.getLogger(Builder.class.getName());
        private Boolean enabled;
        private final List<RequestedUriDiscoveryType> discoveryTypes = new ArrayList<RequestedUriDiscoveryType>();
        private AllowList trustedProxies;
        private String socketId;

        private Builder() {
        }

        public RequestedUriDiscoveryContext build() {
            this.prepareAndCheckRequestedUriSettings();
            return new RequestedUriDiscoveryContextImpl(this);
        }

        public Builder config(Config requestedUriDiscoveryConfig) {
            requestedUriDiscoveryConfig.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            requestedUriDiscoveryConfig.get("discoveryTypes").asList(RequestedUriDiscoveryType.class).ifPresent(this::discoveryTypes);
            requestedUriDiscoveryConfig.get("trusted-proxies").map(AllowList::create).ifPresent(this::trustedProxies);
            return this;
        }

        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder trustedProxies(AllowList trustedProxies) {
            this.trustedProxies = trustedProxies;
            return this;
        }

        public Builder discoveryTypes(List<RequestedUriDiscoveryType> discoveryTypes) {
            this.discoveryTypes.clear();
            this.discoveryTypes.addAll(discoveryTypes);
            return this;
        }

        public Builder addDiscoveryType(RequestedUriDiscoveryType discoveryType) {
            this.discoveryTypes.add(discoveryType);
            return this;
        }

        public Builder socketId(String socketId) {
            this.socketId = socketId;
            return this;
        }

        private void prepareAndCheckRequestedUriSettings() {
            boolean isDiscoveryEnabledDefaulted;
            if (this.socketId == null) {
                throw new IllegalArgumentException("Required socket ID not specified");
            }
            boolean bl = isDiscoveryEnabledDefaulted = this.enabled == null;
            if (this.enabled == null) {
                this.enabled = !this.discoveryTypes.isEmpty() || this.trustedProxies != null;
            }
            boolean areDiscoveryTypesDefaulted = false;
            if (this.enabled.booleanValue()) {
                if (this.discoveryTypes.isEmpty()) {
                    areDiscoveryTypesDefaulted = true;
                    this.discoveryTypes.add(RequestedUriDiscoveryType.FORWARDED);
                }
                if (this.trustedProxies == null && !this.isDiscoveryTypesOnlyHost()) {
                    throw new UnsafeRequestedUriSettingsException(this, areDiscoveryTypesDefaulted);
                }
            } else {
                if (!this.discoveryTypes.isEmpty()) {
                    LOGGER.log(System.Logger.Level.INFO, "Ignoring explicit settings of requested-uri-discovery types and trusted-proxies because\nrequested-uri-discovery.enabled {0} to false\n", isDiscoveryEnabledDefaulted ? " defaulted" : "was set");
                }
                this.discoveryTypes.clear();
                this.discoveryTypes.add(RequestedUriDiscoveryType.HOST);
            }
            if (this.trustedProxies == null) {
                this.trustedProxies = AllowList.builder().addDenied(s -> true).build();
            }
        }

        private boolean isDiscoveryTypesOnlyHost() {
            return this.discoveryTypes.size() == 1 && this.discoveryTypes.contains((Object)RequestedUriDiscoveryType.HOST);
        }

        private static class RequestedUriDiscoveryContextImpl
        implements RequestedUriDiscoveryContext {
            private final boolean enabled;
            private final List<RequestedUriDiscoveryType> discoveryTypes;
            private final AllowList trustedProxies;

            private RequestedUriDiscoveryContextImpl(Builder builder) {
                this.enabled = builder.enabled;
                this.discoveryTypes = builder.discoveryTypes;
                this.trustedProxies = builder.trustedProxies;
            }

            @Override
            public UriInfo uriInfo(String remoteAddress, String localAddress, String requestPath, ServerRequestHeaders headers, UriQuery query, boolean isSecure) {
                String scheme = null;
                String authority = null;
                String host = null;
                int port = -1;
                String path = null;
                if (this.enabled && this.trustedProxies.test(RequestedUriDiscoveryContextImpl.hostPart(remoteAddress))) {
                    block5: for (RequestedUriDiscoveryType type : this.discoveryTypes) {
                        switch (type) {
                            case FORWARDED: {
                                Record discovery = this.discoverUsingForwarded(headers);
                                if (discovery == null) continue block5;
                                authority = ((ForwardedDiscovery)discovery).authority();
                                scheme = ((ForwardedDiscovery)discovery).scheme();
                                break block5;
                            }
                            case X_FORWARDED: {
                                Record discovery = this.discoverUsingXForwarded(headers, requestPath);
                                if (discovery == null) continue block5;
                                scheme = ((XForwardedDiscovery)discovery).scheme();
                                host = ((XForwardedDiscovery)discovery).host();
                                port = ((XForwardedDiscovery)discovery).port();
                                path = ((XForwardedDiscovery)discovery).path();
                                break block5;
                            }
                            case HOST: {
                                authority = headers.first(Http.Header.HOST).orElse(null);
                                break block5;
                            }
                            default: {
                                authority = headers.first(Http.Header.HOST).orElse(null);
                                break block5;
                            }
                        }
                    }
                }
                if (host == null && authority == null) {
                    authority = headers.first(Http.Header.HOST).orElse(null);
                }
                if (path == null) {
                    path = requestPath;
                }
                if (host == null && authority != null) {
                    Authority a = scheme == null ? Authority.create(authority) : Authority.create(scheme, authority);
                    if (a.host() != null) {
                        host = a.host();
                    }
                    if (port == -1) {
                        port = a.port();
                    }
                }
                if (scheme == null) {
                    if (port == 80) {
                        scheme = "http";
                    } else if (port == 443) {
                        scheme = "https";
                    } else {
                        String string = scheme = isSecure ? "https" : "http";
                    }
                }
                if (host == null) {
                    host = localAddress;
                }
                if (port == -1) {
                    port = "https".equals(scheme) ? 443 : 80;
                }
                if (query == null || query.isEmpty()) {
                    query = null;
                }
                return new UriInfo(scheme, host, port, path, Optional.ofNullable(query));
            }

            private static String hostPart(String address) {
                int colon = address.indexOf(58);
                return colon == -1 ? address : address.substring(0, colon);
            }

            private ForwardedDiscovery discoverUsingForwarded(ServerRequestHeaders headers) {
                String scheme = null;
                String authority = null;
                List<Forwarded> forwardedList = Forwarded.create(headers);
                if (!forwardedList.isEmpty()) {
                    for (int i = forwardedList.size() - 1; i >= 0; --i) {
                        Forwarded f = forwardedList.get(i);
                        if (scheme == null && f.proto().isPresent()) {
                            scheme = f.proto().get();
                        }
                        if (authority == null && f.host().isPresent()) {
                            authority = f.host().get();
                        }
                        if (f.forClient().isPresent() && !this.trustedProxies.test(f.forClient().get()) || scheme != null && authority != null) break;
                    }
                }
                return authority != null ? new ForwardedDiscovery(authority, scheme) : null;
            }

            private XForwardedDiscovery discoverUsingXForwarded(ServerRequestHeaders headers, String requestPath) {
                boolean discovered = false;
                String scheme = null;
                String host = null;
                int port = -1;
                String path = null;
                List<String> xForwardedFors = headers.values(Http.Header.X_FORWARDED_FOR);
                boolean areProxiesTrusted = true;
                if (xForwardedFors.size() > 0) {
                    for (int i = 1; i < xForwardedFors.size(); ++i) {
                        areProxiesTrusted &= this.trustedProxies.test(xForwardedFors.get(i));
                    }
                }
                if (areProxiesTrusted) {
                    scheme = headers.first(Http.Header.X_FORWARDED_PROTO).orElse(null);
                    host = headers.first(Http.Header.X_FORWARDED_HOST).orElse(null);
                    port = headers.first(Http.Header.X_FORWARDED_PORT).map(Integer::parseInt).orElse(-1);
                    path = headers.first(Http.Header.X_FORWARDED_PREFIX).map(prefix -> {
                        String absolute = requestPath;
                        return prefix + (absolute.startsWith("/") ? "" : "/") + absolute;
                    }).orElse(null);
                    discovered = scheme != null || host != null || port != -1 || path != null;
                }
                return discovered ? new XForwardedDiscovery(scheme, host, port, path) : null;
            }

            private record ForwardedDiscovery(String authority, String scheme) {
            }

            private record XForwardedDiscovery(String scheme, String host, int port, String path) {
            }

            private record Authority(String host, int port) {
                static Authority create(String hostHeader) {
                    int colon = hostHeader.indexOf(58);
                    if (colon == -1) {
                        return new Authority(hostHeader, -1);
                    }
                    String hostString = hostHeader.substring(0, colon);
                    String portString = hostHeader.substring(colon + 1);
                    return new Authority(hostString, Integer.parseInt(portString));
                }

                static Authority create(String scheme, String hostHeader) {
                    int colon = hostHeader.indexOf(58);
                    if (colon == -1) {
                        return new Authority(hostHeader, "https".equals(scheme) ? 443 : 80);
                    }
                    String hostString = hostHeader.substring(0, colon);
                    String portString = hostHeader.substring(colon + 1);
                    return new Authority(hostString, Integer.parseInt(portString));
                }
            }
        }
    }

    public static class UnsafeRequestedUriSettingsException
    extends RuntimeException {
        UnsafeRequestedUriSettingsException(Builder requestedUriDiscoveryContextBuilder, boolean areDiscoveryTypesDefaulted) {
            super(String.format("Settings which control requested URI discovery for socket %s are unsafe: discovery is enabled with types %s to %s but no trusted proxies were set to protect against forgery of headers. Server start-up will not continue. Please prepare the trusted-proxies allow-list for this socket using 'allow' and/or 'deny' settings. If you choose to start unsafely (not recommended), set trusted-proxies.allow.all to 'true'. ", requestedUriDiscoveryContextBuilder.socketId, areDiscoveryTypesDefaulted ? "defaulted" : "set", requestedUriDiscoveryContextBuilder.discoveryTypes));
        }
    }

    public static enum RequestedUriDiscoveryType {
        FORWARDED,
        X_FORWARDED,
        HOST;

    }
}

