/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.DirectHandler;
import io.helidon.common.http.Http;
import io.helidon.common.http.ServerResponseHeaders;

public class RequestException
extends RuntimeException {
    private final DirectHandler.EventType eventType;
    private final Http.Status status;
    private final DirectHandler.TransportRequest transportRequest;
    private final boolean keepAlive;
    private final ServerResponseHeaders responseHeaders;

    protected RequestException(Builder builder) {
        super(builder.message, builder.cause);
        this.eventType = builder.type;
        this.status = builder.status;
        this.transportRequest = builder.request;
        this.keepAlive = builder.keepAlive;
        this.responseHeaders = builder.responseHeaders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Http.Status status() {
        return this.status;
    }

    public DirectHandler.EventType eventType() {
        return this.eventType;
    }

    public DirectHandler.TransportRequest request() {
        return this.transportRequest;
    }

    public boolean keepAlive() {
        return this.keepAlive;
    }

    public ServerResponseHeaders responseHeaders() {
        return this.responseHeaders;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, RequestException> {
        private String message;
        private Throwable cause;
        private DirectHandler.TransportRequest request;
        private DirectHandler.EventType type;
        private Http.Status status;
        private Boolean keepAlive;
        private final ServerResponseHeaders responseHeaders = ServerResponseHeaders.create();

        private Builder() {
        }

        public RequestException build() {
            if (this.message == null) {
                this.message = "";
            }
            if (this.request == null) {
                this.request = DirectHandler.TransportRequest.empty();
            }
            if (this.type == null) {
                this.type(DirectHandler.EventType.INTERNAL_ERROR);
            }
            return new RequestException(this);
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder request(DirectHandler.TransportRequest request) {
            this.request = request;
            return this;
        }

        public Builder type(DirectHandler.EventType type) {
            this.type = type;
            if (this.status == null) {
                this.status = type.defaultStatus();
            }
            if (this.keepAlive == null) {
                this.keepAlive = type.keepAlive();
            }
            return this;
        }

        public Builder status(Http.Status status) {
            this.status = status;
            return this;
        }

        public Builder setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder header(Http.HeaderValue header) {
            this.responseHeaders.set(header);
            return this;
        }
    }
}

