/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.buffers.Ascii;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.LazyString;
import io.helidon.common.http.HeaderEnum;
import io.helidon.common.http.HeaderImpl;
import io.helidon.common.http.HeaderValueArray;
import io.helidon.common.http.HeaderValueCached;
import io.helidon.common.http.HeaderValueCopy;
import io.helidon.common.http.HeaderValueLazy;
import io.helidon.common.http.HeaderValueList;
import io.helidon.common.http.HeaderValueSingle;
import io.helidon.common.http.HttpToken;
import io.helidon.common.http.MethodHelper;
import io.helidon.common.http.MethodPredicates;
import io.helidon.common.http.StatusHelper;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class Http {
    private Http() {
    }

    public static final class DateTime {
        public static final DateTimeFormatter RFC_850_DATE_TIME;
        public static final DateTimeFormatter RFC_1123_DATE_TIME;
        public static final DateTimeFormatter ASCTIME_DATE_TIME;
        private static final Map<Long, String> MONTH_NAME_3D;
        private static volatile String rfc1123String;
        private static volatile byte[] http1valueBytes;

        private DateTime() {
        }

        public static ZonedDateTime parse(String text) {
            try {
                return ZonedDateTime.parse(text, RFC_1123_DATE_TIME);
            }
            catch (DateTimeParseException pe) {
                try {
                    return ZonedDateTime.parse(text, RFC_850_DATE_TIME);
                }
                catch (DateTimeParseException pe2) {
                    return ZonedDateTime.parse(text, ASCTIME_DATE_TIME);
                }
            }
        }

        public static String rfc1123String() {
            return rfc1123String;
        }

        public static byte[] http1Bytes() {
            return http1valueBytes;
        }

        static void update() {
            rfc1123String = ZonedDateTime.now().format(RFC_1123_DATE_TIME);
            http1valueBytes = (rfc1123String + "\r\n").getBytes(StandardCharsets.US_ASCII);
        }

        static {
            RFC_1123_DATE_TIME = DateTimeFormatter.RFC_1123_DATE_TIME;
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(1L, "Jan");
            map.put(2L, "Feb");
            map.put(3L, "Mar");
            map.put(4L, "Apr");
            map.put(5L, "May");
            map.put(6L, "Jun");
            map.put(7L, "Jul");
            map.put(8L, "Aug");
            map.put(9L, "Sep");
            map.put(10L, "Oct");
            map.put(11L, "Nov");
            map.put(12L, "Dec");
            MONTH_NAME_3D = Collections.unmodifiableMap(map);
            Map<Long, String> dayOfWeekFull = Map.of(1L, "Monday", 2L, "Tuesday", 3L, "Wednesday", 4L, "Thursday", 5L, "Friday", 6L, "Saturday", 7L, "Sunday");
            RFC_850_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dayOfWeekFull).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, MONTH_NAME_3D).appendLiteral('-').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDate.now().minusYears(50L).getYear()).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "GMT").toFormatter();
            Map<Long, String> dayOfWeek3d = Map.of(1L, "Mon", 2L, "Tue", 3L, "Wed", 4L, "Thu", 5L, "Fri", 6L, "Sat", 7L, "Sun");
            ASCTIME_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dayOfWeek3d).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, MONTH_NAME_3D).appendLiteral(' ').padNext(2).appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendValue(ChronoField.YEAR, 4).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();
            DateTime.update();
            Thread thread = new Thread(() -> {
                while (true) {
                    DateTime.update();
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }, "helidon-http-timer");
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static final class HeaderValues {
        public static final HeaderValue ACCEPT_RANGES_BYTES = Header.createCached(Header.ACCEPT_RANGES, "bytes");
        public static final HeaderValue ACCEPT_RANGES_NONE = Header.createCached(Header.ACCEPT_RANGES, "none");
        public static final HeaderValue TRANSFER_ENCODING_CHUNKED = Header.createCached(Header.TRANSFER_ENCODING, "chunked");
        public static final HeaderValue CONNECTION_KEEP_ALIVE = Header.createCached(Header.CONNECTION, "keep-alive");
        public static final HeaderValue CONNECTION_CLOSE = Header.createCached(Header.CONNECTION, "close");
        public static final HeaderValue CONTENT_TYPE_JSON = Header.createCached(Header.CONTENT_TYPE, "application/json");
        public static final HeaderValue CONTENT_TYPE_TEXT_PLAIN = Header.createCached(Header.CONTENT_TYPE, "text/plain");
        public static final HeaderValue CONTENT_TYPE_OCTET_STREAM = Header.createCached(Header.CONTENT_TYPE, "application/octet-stream");
        public static final HeaderValue CONTENT_TYPE_EVENT_STREAM = Header.createCached(Header.CONTENT_TYPE, "text/event-stream");
        public static final HeaderValue ACCEPT_JSON = Header.createCached(Header.ACCEPT, "application/json");
        public static final HeaderValue ACCEPT_TEXT = Header.createCached(Header.ACCEPT, "text/plain;charset=UTF-8");
        public static final HeaderValue ACCEPT_EVENT_STREAM = Header.createCached(Header.ACCEPT, "text/event-stream");
        public static final HeaderValue EXPECT_100 = Header.createCached(Header.EXPECT, "100-continue");
        public static final HeaderValue CONTENT_LENGTH_ZERO = Header.createCached(Header.CONTENT_LENGTH, "0");
        public static final HeaderValue CACHE_NO_CACHE = Header.create(Header.CACHE_CONTROL, "no-cache", "no-store", "must-revalidate", "no-transform");
        public static final HeaderValue CACHE_NORMAL = Header.createCached(Header.CACHE_CONTROL, "no-transform");
        public static final HeaderValue TE_TRAILERS = Header.createCached(Header.TE, "trailers");

        private HeaderValues() {
        }
    }

    public static final class Header {
        public static final HeaderName ACCEPT = HeaderEnum.ACCEPT;
        public static final HeaderName ACCEPT_CHARSET = HeaderEnum.ACCEPT_CHARSET;
        public static final HeaderName ACCEPT_ENCODING = HeaderEnum.ACCEPT_ENCODING;
        public static final HeaderName ACCEPT_LANGUAGE = HeaderEnum.ACCEPT_LANGUAGE;
        public static final HeaderName ACCEPT_DATETIME = HeaderEnum.ACCEPT_DATETIME;
        public static final HeaderName ACCESS_CONTROL_ALLOW_CREDENTIALS = HeaderEnum.ACCESS_CONTROL_ALLOW_CREDENTIALS;
        public static final HeaderName ACCESS_CONTROL_ALLOW_HEADERS = HeaderEnum.ACCESS_CONTROL_ALLOW_HEADERS;
        public static final HeaderName ACCESS_CONTROL_ALLOW_METHODS = HeaderEnum.ACCESS_CONTROL_ALLOW_METHODS;
        public static final HeaderName ACCESS_CONTROL_ALLOW_ORIGIN = HeaderEnum.ACCESS_CONTROL_ALLOW_ORIGIN;
        public static final HeaderName ACCESS_CONTROL_EXPOSE_HEADERS = HeaderEnum.ACCESS_CONTROL_EXPOSE_HEADERS;
        public static final HeaderName ACCESS_CONTROL_MAX_AGE = HeaderEnum.ACCESS_CONTROL_MAX_AGE;
        public static final HeaderName ACCESS_CONTROL_REQUEST_HEADERS = HeaderEnum.ACCESS_CONTROL_REQUEST_HEADERS;
        public static final HeaderName ACCESS_CONTROL_REQUEST_METHOD = HeaderEnum.ACCESS_CONTROL_REQUEST_METHOD;
        public static final HeaderName AUTHORIZATION = HeaderEnum.AUTHORIZATION;
        public static final HeaderName COOKIE = HeaderEnum.COOKIE;
        public static final HeaderName EXPECT = HeaderEnum.EXPECT;
        public static final HeaderName FORWARDED = HeaderEnum.FORWARDED;
        public static final HeaderName FROM = HeaderEnum.FROM;
        public static final HeaderName HOST = HeaderEnum.HOST;
        public static final String HOST_STRING = "Host";
        public static final HeaderName IF_MATCH = HeaderEnum.IF_MATCH;
        public static final HeaderName IF_MODIFIED_SINCE = HeaderEnum.IF_MODIFIED_SINCE;
        public static final HeaderName IF_NONE_MATCH = HeaderEnum.IF_NONE_MATCH;
        public static final HeaderName IF_RANGE = HeaderEnum.IF_RANGE;
        public static final HeaderName IF_UNMODIFIED_SINCE = HeaderEnum.IF_UNMODIFIED_SINCE;
        public static final HeaderName MAX_FORWARDS = HeaderEnum.MAX_FORWARDS;
        public static final HeaderName ORIGIN = HeaderEnum.ORIGIN;
        public static final HeaderName PROXY_AUTHENTICATE = HeaderEnum.PROXY_AUTHENTICATE;
        public static final HeaderName PROXY_AUTHORIZATION = HeaderEnum.PROXY_AUTHORIZATION;
        public static final HeaderName RANGE = HeaderEnum.RANGE;
        public static final HeaderName REFERER = HeaderEnum.REFERER;
        public static final HeaderName REFRESH = HeaderEnum.REFRESH;
        public static final HeaderName TE = HeaderEnum.TE;
        public static final HeaderName USER_AGENT = HeaderEnum.USER_AGENT;
        public static final HeaderName VIA = HeaderEnum.VIA;
        public static final HeaderName ACCEPT_PATCH = HeaderEnum.ACCEPT_PATCH;
        public static final HeaderName ACCEPT_RANGES = HeaderEnum.ACCEPT_RANGES;
        public static final HeaderName AGE = HeaderEnum.AGE;
        public static final HeaderName ALLOW = HeaderEnum.ALLOW;
        public static final HeaderName ALT_SVC = HeaderEnum.ALT_SVC;
        public static final HeaderName CACHE_CONTROL = HeaderEnum.CACHE_CONTROL;
        public static final HeaderName CONNECTION = HeaderEnum.CONNECTION;
        public static final HeaderName CONTENT_DISPOSITION = HeaderEnum.CONTENT_DISPOSITION;
        public static final HeaderName CONTENT_ENCODING = HeaderEnum.CONTENT_ENCODING;
        public static final HeaderName CONTENT_LANGUAGE = HeaderEnum.CONTENT_LANGUAGE;
        public static final HeaderName CONTENT_LENGTH = HeaderEnum.CONTENT_LENGTH;
        public static final HeaderName CONTENT_LOCATION = HeaderEnum.CONTENT_LOCATION;
        public static final HeaderName CONTENT_RANGE = HeaderEnum.CONTENT_RANGE;
        public static final HeaderName CONTENT_TYPE = HeaderEnum.CONTENT_TYPE;
        public static final HeaderName DATE = HeaderEnum.DATE;
        public static final HeaderName ETAG = HeaderEnum.ETAG;
        public static final HeaderName EXPIRES = HeaderEnum.EXPIRES;
        public static final HeaderName LAST_MODIFIED = HeaderEnum.LAST_MODIFIED;
        public static final HeaderName LINK = HeaderEnum.LINK;
        public static final HeaderName LOCATION = HeaderEnum.LOCATION;
        public static final HeaderName PRAGMA = HeaderEnum.PRAGMA;
        public static final HeaderName PUBLIC_KEY_PINS = HeaderEnum.PUBLIC_KEY_PINS;
        public static final HeaderName RETRY_AFTER = HeaderEnum.RETRY_AFTER;
        public static final HeaderName SERVER = HeaderEnum.SERVER;
        public static final HeaderName SET_COOKIE = HeaderEnum.SET_COOKIE;
        public static final HeaderName SET_COOKIE2 = HeaderEnum.SET_COOKIE2;
        public static final HeaderName STRICT_TRANSPORT_SECURITY = HeaderEnum.STRICT_TRANSPORT_SECURITY;
        public static final HeaderName TRAILER = HeaderEnum.TRAILER;
        public static final HeaderName TRANSFER_ENCODING = HeaderEnum.TRANSFER_ENCODING;
        public static final HeaderName TSV = HeaderEnum.TSV;
        public static final HeaderName UPGRADE = HeaderEnum.UPGRADE;
        public static final HeaderName VARY = HeaderEnum.VARY;
        public static final HeaderName WARNING = HeaderEnum.WARNING;
        public static final HeaderName WWW_AUTHENTICATE = HeaderEnum.WWW_AUTHENTICATE;
        public static final HeaderName X_HELIDON_CN = HeaderEnum.X_HELIDON_CN;
        public static final HeaderName X_FORWARDED_FOR = HeaderEnum.X_FORWARDED_FOR;
        public static final HeaderName X_FORWARDED_HOST = HeaderEnum.X_FORWARDED_HOST;
        public static final HeaderName X_FORWARDED_PORT = HeaderEnum.X_FORWARDED_PORT;
        public static final HeaderName X_FORWARDED_PREFIX = HeaderEnum.X_FORWARDED_PREFIX;
        public static final HeaderName X_FORWARDED_PROTO = HeaderEnum.X_FORWARDED_PROTO;

        private Header() {
        }

        public static HeaderName create(String name) {
            HeaderName headerName = HeaderEnum.byCapitalizedName(name);
            if (headerName == null) {
                return new HeaderImpl(Ascii.toLowerCase((String)name), name);
            }
            return headerName;
        }

        public static HeaderName createName(String lowerCase, String defaultCase) {
            HeaderName headerName = HeaderEnum.byName(lowerCase);
            if (headerName == null) {
                return new HeaderImpl(lowerCase, defaultCase);
            }
            return headerName;
        }

        public static HeaderName createFromLowercase(String lowerCase) {
            if (!Ascii.toLowerCase((String)lowerCase).equals(lowerCase)) {
                throw new IllegalArgumentException("Lower case string required: " + lowerCase);
            }
            HeaderName headerName = HeaderEnum.byName(lowerCase);
            if (headerName == null) {
                return new HeaderImpl(lowerCase, lowerCase);
            }
            return headerName;
        }

        public static HeaderValue createCached(String name, String value) {
            return Header.createCached(Header.create(name), value);
        }

        public static HeaderValue createCached(HeaderName name, String value) {
            return new HeaderValueCached(name, false, false, value.getBytes(StandardCharsets.US_ASCII), value);
        }

        public static HeaderValue createCached(HeaderName name, int value) {
            return Header.createCached(name, String.valueOf(value));
        }

        public static HeaderValue create(HeaderName name, LazyString value) {
            return new HeaderValueLazy(name, false, false, value);
        }

        public static HeaderValue create(HeaderName name, int value) {
            return new HeaderValueSingle(name, false, false, String.valueOf(value));
        }

        public static HeaderValue create(HeaderName name, long value) {
            return new HeaderValueSingle(name, false, false, String.valueOf(value));
        }

        public static HeaderValue create(HeaderName name, String value) {
            return new HeaderValueSingle(name, false, false, value);
        }

        public static HeaderValue create(HeaderName name, String ... values) {
            return new HeaderValueArray(name, false, false, values);
        }

        public static HeaderValue create(HeaderName name, List<String> values) {
            return new HeaderValueList(name, false, false, values);
        }

        public static HeaderValue createCached(HeaderName name, boolean changing, boolean sensitive, String value) {
            return new HeaderValueCached(name, changing, sensitive, value.getBytes(StandardCharsets.UTF_8), value);
        }

        public static HeaderValue create(HeaderName name, boolean changing, boolean sensitive, String ... values) {
            return new HeaderValueArray(name, changing, sensitive, values);
        }
    }

    public static interface HeaderValueWriteable
    extends HeaderValue {
        public static HeaderValueWriteable create(HeaderValue header) {
            return new HeaderValueCopy(header);
        }

        public HeaderValueWriteable addValue(String var1);
    }

    public static interface HeaderValue {
        public String name();

        public HeaderName headerName();

        public String value();

        public <T> T value(Class<T> var1);

        default public String values() {
            return String.join((CharSequence)",", this.allValues());
        }

        public List<String> allValues();

        default public List<String> allValues(boolean split) {
            if (split) {
                List<String> values = this.allValues();
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.contains(", ")) {
                        return List.of(value.split(", "));
                    }
                    return List.of(value);
                }
                return values;
            }
            return this.allValues();
        }

        public int valueCount();

        public boolean sensitive();

        public boolean changing();

        default public byte[] valueBytes() {
            return this.value().getBytes(StandardCharsets.US_ASCII);
        }

        default public void writeHttp1Header(BufferData buffer) {
            byte[] nameBytes = this.name().getBytes(StandardCharsets.US_ASCII);
            if (this.valueCount() == 1) {
                this.writeHeader(buffer, nameBytes, this.valueBytes());
            } else {
                for (String value : this.allValues()) {
                    this.writeHeader(buffer, nameBytes, value.getBytes(StandardCharsets.US_ASCII));
                }
            }
        }

        private void writeHeader(BufferData buffer, byte[] nameBytes, byte[] valueBytes) {
            buffer.write(nameBytes);
            buffer.write(58);
            buffer.write(32);
            buffer.write(valueBytes);
            buffer.write(13);
            buffer.write(10);
        }
    }

    public static sealed interface HeaderName
    permits HeaderImpl, HeaderEnum {
        public String lowerCase();

        public String defaultCase();

        default public int index() {
            return -1;
        }

        default public boolean isPseudoHeader() {
            return this.lowerCase().charAt(0) == ':';
        }
    }

    public static class Status {
        public static final Status CONTINUE_100 = new Status(100, "Continue", true);
        public static final Status SWITCHING_PROTOCOLS_101 = new Status(101, "Switching Protocols", true);
        public static final Status OK_200 = new Status(200, "OK", true);
        public static final Status CREATED_201 = new Status(201, "Created", true);
        public static final Status ACCEPTED_202 = new Status(202, "Accepted", true);
        public static final Status NO_CONTENT_204 = new Status(204, "No Content", true);
        public static final Status RESET_CONTENT_205 = new Status(205, "Reset Content", true);
        public static final Status PARTIAL_CONTENT_206 = new Status(206, "Partial Content", true);
        public static final Status MOVED_PERMANENTLY_301 = new Status(301, "Moved Permanently", true);
        public static final Status FOUND_302 = new Status(302, "Found", true);
        public static final Status SEE_OTHER_303 = new Status(303, "See Other", true);
        public static final Status NOT_MODIFIED_304 = new Status(304, "Not Modified", true);
        public static final Status USE_PROXY_305 = new Status(305, "Use Proxy", true);
        public static final Status TEMPORARY_REDIRECT_307 = new Status(307, "Temporary Redirect", true);
        public static final Status BAD_REQUEST_400 = new Status(400, "Bad Request", true);
        public static final Status UNAUTHORIZED_401 = new Status(401, "Unauthorized", true);
        public static final Status PAYMENT_REQUIRED_402 = new Status(402, "Payment Required", true);
        public static final Status FORBIDDEN_403 = new Status(403, "Forbidden", true);
        public static final Status NOT_FOUND_404 = new Status(404, "Not Found", true);
        public static final Status METHOD_NOT_ALLOWED_405 = new Status(405, "Method Not Allowed", true);
        public static final Status NOT_ACCEPTABLE_406 = new Status(406, "Not Acceptable", true);
        public static final Status PROXY_AUTHENTICATION_REQUIRED_407 = new Status(407, "Proxy Authentication Required", true);
        public static final Status REQUEST_TIMEOUT_408 = new Status(408, "Request Timeout", true);
        public static final Status CONFLICT_409 = new Status(409, "Conflict", true);
        public static final Status GONE_410 = new Status(410, "Gone", true);
        public static final Status LENGTH_REQUIRED_411 = new Status(411, "Length Required", true);
        public static final Status PRECONDITION_FAILED_412 = new Status(412, "Precondition Failed", true);
        public static final Status REQUEST_ENTITY_TOO_LARGE_413 = new Status(413, "Request Entity Too Large", true);
        public static final Status REQUEST_URI_TOO_LONG_414 = new Status(414, "Request-URI Too Long", true);
        public static final Status UNSUPPORTED_MEDIA_TYPE_415 = new Status(415, "Unsupported Media Type", true);
        public static final Status REQUESTED_RANGE_NOT_SATISFIABLE_416 = new Status(416, "Requested Range Not Satisfiable", true);
        public static final Status EXPECTATION_FAILED_417 = new Status(417, "Expectation Failed", true);
        public static final Status I_AM_A_TEAPOT_418 = new Status(418, "I'm a teapot", true);
        public static final Status INTERNAL_SERVER_ERROR_500 = new Status(500, "Internal Server Error", true);
        public static final Status NOT_IMPLEMENTED_501 = new Status(501, "Not Implemented", true);
        public static final Status BAD_GATEWAY_502 = new Status(502, "Bad Gateway", true);
        public static final Status SERVICE_UNAVAILABLE_503 = new Status(503, "Service Unavailable", true);
        public static final Status GATEWAY_TIMEOUT_504 = new Status(504, "Gateway Timeout", true);
        @Deprecated(forRemoval=true, since="3.0.3")
        public static final Status HTTP_VERSION_NOT_SUPPORTED = new Status(505, "HTTP Version Not Supported", true);
        public static final Status HTTP_VERSION_NOT_SUPPORTED_505 = new Status(505, "HTTP Version Not Supported", true);
        private final int code;
        private final String reason;
        private final Family family;
        private final String codeText;
        private final String stringValue;

        private Status(int statusCode, String reasonPhrase, boolean instance) {
            this.code = statusCode;
            this.reason = reasonPhrase;
            this.family = Family.of(statusCode);
            this.codeText = String.valueOf(this.code);
            this.stringValue = this.code + " " + this.reason;
            if (instance) {
                StatusHelper.add(this);
            }
        }

        private Status(int statusCode, String reasonPhrase, Family family, String codeText) {
            this.code = statusCode;
            this.reason = reasonPhrase;
            this.family = family;
            this.codeText = codeText;
            this.stringValue = this.code + " " + this.reason;
        }

        public static Status create(int statusCode) {
            Status found = StatusHelper.find(statusCode);
            if (found == null) {
                return Status.createNew(Family.of(statusCode), statusCode, "", String.valueOf(statusCode));
            }
            return found;
        }

        public static Status create(int statusCode, String reasonPhrase) {
            Status found = StatusHelper.find(statusCode);
            if (found == null) {
                return Status.createNew(Family.of(statusCode), statusCode, reasonPhrase, String.valueOf(statusCode));
            }
            if (reasonPhrase == null) {
                return found;
            }
            if (found.reasonPhrase().equalsIgnoreCase(reasonPhrase)) {
                return found;
            }
            return Status.createNew(found.family(), statusCode, reasonPhrase, found.codeText());
        }

        private static Status createNew(Family family, int statusCode, String reasonPhrase, String codeText) {
            return new Status(statusCode, reasonPhrase, family, codeText);
        }

        public int code() {
            return this.code;
        }

        public Family family() {
            return this.family;
        }

        public String reasonPhrase() {
            return this.reason;
        }

        public String codeText() {
            return this.codeText;
        }

        public String toString() {
            return this.stringValue;
        }

        public String text() {
            return this.stringValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.code == status.code && this.reason.equals(status.reason);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.reason);
        }

        static {
            StatusHelper.statusesDone();
        }

        public static enum Family {
            INFORMATIONAL,
            SUCCESSFUL,
            REDIRECTION,
            CLIENT_ERROR,
            SERVER_ERROR,
            OTHER;


            public static Family of(int statusCode) {
                return switch (statusCode / 100) {
                    case 1 -> INFORMATIONAL;
                    case 2 -> SUCCESSFUL;
                    case 3 -> REDIRECTION;
                    case 4 -> CLIENT_ERROR;
                    case 5 -> SERVER_ERROR;
                    default -> OTHER;
                };
            }
        }
    }

    public static interface MethodPredicate
    extends Predicate<Method> {
        public Set<Method> acceptedMethods();
    }

    public static final class Method {
        private static final String GET_STRING = "GET";
        public static final Method GET = new Method("GET", true);
        public static final Method POST = new Method("POST", true);
        public static final Method PUT = new Method("PUT", true);
        public static final Method DELETE = new Method("DELETE", true);
        public static final Method HEAD = new Method("HEAD", true);
        public static final Method OPTIONS = new Method("OPTIONS", true);
        public static final Method TRACE = new Method("TRACE", true);
        public static final Method PATCH = new Method("PATCH", true);
        private final String name;
        private final int length;
        private final boolean instance;

        private Method(String name, boolean instance) {
            this.name = name;
            this.length = name.length();
            this.instance = instance;
            if (instance) {
                MethodHelper.add(this);
            }
        }

        public static Method create(String name) {
            if (name.equals(GET_STRING)) {
                return GET;
            }
            String methodName = Ascii.toUpperCase((String)name);
            Method method = MethodHelper.byName(methodName);
            if (method == null) {
                HttpToken.validate(methodName);
                return new Method(methodName, false);
            }
            return method;
        }

        public static MethodPredicate predicate(Method ... methods) {
            return switch (methods.length) {
                case 0 -> MethodPredicates.TruePredicate.get();
                case 1 -> {
                    if (methods[0].instance) {
                        yield new MethodPredicates.SingleMethodEnumPredicate(methods[0]);
                    }
                    yield new MethodPredicates.SingleMethodPredicate(methods[0]);
                }
                default -> new MethodPredicates.MethodsPredicate(methods);
            };
        }

        public static MethodPredicate predicate(Collection<Method> methods) {
            switch (methods.size()) {
                case 0: {
                    return MethodPredicates.TruePredicate.get();
                }
                case 1: {
                    Method first = methods.iterator().next();
                    return first.instance ? new MethodPredicates.SingleMethodEnumPredicate(first) : new MethodPredicates.SingleMethodPredicate(first);
                }
            }
            return new MethodPredicates.MethodsPredicate(methods.toArray(new Method[0]));
        }

        @Deprecated
        public String name() {
            return this.text();
        }

        public String text() {
            return this.name;
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return this.text();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Method method = (Method)o;
            return this.name.equals(method.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        static {
            MethodHelper.methodsDone();
        }
    }

    public static enum Version {
        V1_0("HTTP/1.0"),
        V1_1("HTTP/1.1"),
        V2_0("HTTP/2.0");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        public static Version create(String version) {
            Objects.requireNonNull(version, "Version value is null!");
            for (Version v : Version.values()) {
                if (!version.equals(v.value)) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown HTTP version: " + version + "!");
        }

        public String value() {
            return this.value;
        }
    }
}

