/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.HeaderValueBase;
import io.helidon.common.http.Http;
import java.util.ArrayList;
import java.util.List;

class HeaderValueArray
extends HeaderValueBase {
    private final String[] originalValues;
    private List<String> values;

    HeaderValueArray(Http.HeaderName name, boolean changing, boolean sensitive, String[] values) {
        super(name, changing, sensitive, values[0]);
        this.originalValues = values;
    }

    @Override
    public Http.HeaderValueWriteable addValue(String value) {
        if (this.values == null) {
            this.values = new ArrayList<String>(this.originalValues.length + 1);
            this.values.addAll(List.of(this.originalValues));
        }
        this.values.add(value);
        return this;
    }

    @Override
    public List<String> allValues() {
        if (this.values == null) {
            this.values = new ArrayList<String>(List.of(this.originalValues));
        }
        return this.values;
    }

    @Override
    public int valueCount() {
        if (this.values == null) {
            return this.originalValues.length;
        }
        return this.values.size();
    }
}

