/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class Forwarded {
    private static final System.Logger LOGGER = System.getLogger(Forwarded.class.getName());
    private final Optional<String> by;
    private final Optional<String> forClient;
    private final Optional<String> host;
    private final Optional<String> proto;

    private Forwarded(String by, String forClient, String host, String proto) {
        this.by = Optional.ofNullable(by);
        this.forClient = Optional.ofNullable(forClient);
        this.host = Optional.ofNullable(host);
        this.proto = Optional.ofNullable(proto);
    }

    public static Forwarded create(String string) {
        String[] directives = string.split(";");
        String by = null;
        String forClient = null;
        String host = null;
        String proto = null;
        block12: for (String directive : directives) {
            int index = directive.indexOf(61);
            if (index == -1 && !directive.isEmpty()) {
                throw new IllegalArgumentException("Invalid Forwarded header");
            }
            String name = directive.substring(0, index);
            String value = Forwarded.unquote(directive.substring(index + 1));
            switch (name.toLowerCase(Locale.ROOT)) {
                case "by": {
                    by = value;
                    continue block12;
                }
                case "for": {
                    forClient = value;
                    continue block12;
                }
                case "host": {
                    host = value;
                    continue block12;
                }
                case "proto": {
                    proto = value;
                    continue block12;
                }
                default: {
                    if (!LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue block12;
                    String printableName = name.replaceAll("\\p{C}", "?");
                    String printableValue = value.replaceAll("\\p{C}", "?");
                    LOGGER.log(System.Logger.Level.DEBUG, "Encountered unknown directive of Forwarded header: \n" + printableName + "\nValue:\n" + printableValue);
                }
            }
        }
        return new Forwarded(by, forClient, host, proto);
    }

    public static List<Forwarded> create(Headers headers) {
        List<String> values = headers.values(Http.Header.FORWARDED);
        return values.isEmpty() ? List.of() : values.stream().flatMap(it -> Arrays.stream(it.split(","))).map(String::trim).map(Forwarded::create).toList();
    }

    public Optional<String> by() {
        return this.by;
    }

    public Optional<String> forClient() {
        return this.forClient;
    }

    public Optional<String> host() {
        return this.host;
    }

    public Optional<String> proto() {
        return this.proto;
    }

    private static String unquote(String string) {
        if (string.indexOf(34) == 0 && string.lastIndexOf(34) == string.length() - 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

