/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Http;
import java.util.Set;

class MethodPredicates {
    MethodPredicates() {
    }

    static class MethodsPredicate
    implements Http.MethodPredicate {
        private final Set<Http.Method> methods;

        MethodsPredicate(Http.Method ... methods) {
            this.methods = Set.of(methods);
        }

        @Override
        public boolean test(Http.Method method) {
            return this.methods.contains(method);
        }

        @Override
        public Set<Http.Method> acceptedMethods() {
            return this.methods;
        }

        public String toString() {
            return String.join((CharSequence)", ", this.methods.stream().map(Http.Method::text).toList());
        }
    }

    static class SingleMethodPredicate
    implements Http.MethodPredicate {
        private final Http.Method method;
        private final Set<Http.Method> accepted;

        SingleMethodPredicate(Http.Method method) {
            this.method = method;
            this.accepted = Set.of(method);
        }

        @Override
        public boolean test(Http.Method method) {
            return method.equals(this.method);
        }

        @Override
        public Set<Http.Method> acceptedMethods() {
            return this.accepted;
        }

        public String toString() {
            return this.method.text();
        }
    }

    static class SingleMethodEnumPredicate
    implements Http.MethodPredicate {
        private final Http.Method method;
        private final Set<Http.Method> accepted;

        SingleMethodEnumPredicate(Http.Method method) {
            this.method = method;
            this.accepted = Set.of(method);
        }

        @Override
        public boolean test(Http.Method method) {
            return method == this.method;
        }

        @Override
        public Set<Http.Method> acceptedMethods() {
            return this.accepted;
        }

        public String toString() {
            return this.method.text();
        }
    }

    static class TruePredicate
    implements Http.MethodPredicate {
        private static final TruePredicate INSTANCE = new TruePredicate();

        TruePredicate() {
        }

        static Http.MethodPredicate get() {
            return INSTANCE;
        }

        @Override
        public boolean test(Http.Method t) {
            return true;
        }

        @Override
        public Set<Http.Method> acceptedMethods() {
            return Set.of();
        }

        public String toString() {
            return "(any method)";
        }
    }
}

