/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.HeaderEnum;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpMediaType;
import io.helidon.common.http.Utils;
import io.helidon.common.media.type.MediaType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface Headers
extends Iterable<Http.HeaderValue> {
    @Deprecated(forRemoval=true)
    default public List<String> all(String headerName) {
        return this.all(Http.Header.create(headerName), List::of);
    }

    public List<String> all(Http.HeaderName var1, Supplier<List<String>> var2);

    public boolean contains(Http.HeaderName var1);

    public boolean contains(Http.HeaderValue var1);

    public Http.HeaderValue get(Http.HeaderName var1);

    default public Optional<String> value(Http.HeaderName headerName) {
        if (this.contains(headerName)) {
            List<String> hdrs = this.all(headerName, List::of);
            return Optional.of(String.join((CharSequence)",", hdrs));
        }
        return Optional.empty();
    }

    default public Optional<String> first(Http.HeaderName headerName) {
        if (this.contains(headerName)) {
            return Optional.of(this.get(headerName).value());
        }
        return Optional.empty();
    }

    default public List<String> values(Http.HeaderName headerName) {
        return this.all(headerName, List::of).stream().flatMap(val -> Utils.tokenize(',', "\"", true, val).stream()).collect(Collectors.toList());
    }

    default public OptionalLong contentLength() {
        if (this.contains(HeaderEnum.CONTENT_LENGTH)) {
            return OptionalLong.of(this.get(HeaderEnum.CONTENT_LENGTH).value(Long.TYPE));
        }
        return OptionalLong.empty();
    }

    default public Optional<HttpMediaType> contentType() {
        if (this.contains(HeaderEnum.CONTENT_TYPE)) {
            return Optional.of(HttpMediaType.create(this.get(HeaderEnum.CONTENT_TYPE).value()));
        }
        return Optional.empty();
    }

    public int size();

    public List<HttpMediaType> acceptedTypes();

    default public boolean isAccepted(MediaType mediaType) {
        return true;
    }

    @Deprecated(forRemoval=true)
    default public Map<String, List<String>> toMap() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        this.forEach(it -> headers.put(it.name(), it.allValues()));
        return headers;
    }
}

