/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.buffers.LazyString;
import io.helidon.common.http.HeaderValueBase;
import io.helidon.common.http.Http;
import java.util.ArrayList;
import java.util.List;

class HeaderValueLazy
extends HeaderValueBase {
    private final LazyString value;
    private List<String> values;

    HeaderValueLazy(Http.HeaderName name, boolean changing, boolean sensitive, LazyString value) {
        super(name, changing, sensitive, null);
        this.value = value;
    }

    @Override
    public Http.HeaderValueWriteable addValue(String value) {
        if (this.values == null) {
            this.values = new ArrayList<String>(2);
            this.values.add(this.value.stripOws());
        }
        this.values.add(value);
        return this;
    }

    @Override
    public String value() {
        return this.value.stripOws();
    }

    @Override
    public List<String> allValues() {
        if (this.values == null) {
            this.values = new ArrayList<String>(2);
            this.values.add(this.value.stripOws());
        }
        return this.values;
    }

    @Override
    public int valueCount() {
        if (this.values == null) {
            return 1;
        }
        return this.values.size();
    }
}

