/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Http;
import io.helidon.common.mapper.MapperManager;
import java.util.Objects;

abstract class HeaderValueBase
implements Http.HeaderValueWriteable {
    private static final MapperManager MAPPER_MANAGER = MapperManager.create();
    private final Http.HeaderName name;
    private final String actualName;
    private final String firstValue;
    private final boolean changing;
    private final boolean sensitive;

    HeaderValueBase(Http.HeaderName name, boolean changing, boolean sensitive, String value) {
        this.name = name;
        this.actualName = name.defaultCase();
        this.changing = changing;
        this.sensitive = sensitive;
        this.firstValue = value;
    }

    @Override
    public abstract Http.HeaderValueWriteable addValue(String var1);

    @Override
    public String name() {
        return this.actualName;
    }

    @Override
    public Http.HeaderName headerName() {
        return this.name;
    }

    @Override
    public String value() {
        return this.firstValue;
    }

    @Override
    public <T> T value(Class<T> type) {
        return (T)MAPPER_MANAGER.map((Object)this.value(), String.class, type, new String[]{"http-header"});
    }

    @Override
    public abstract int valueCount();

    @Override
    public boolean sensitive() {
        return this.sensitive;
    }

    @Override
    public boolean changing() {
        return this.changing;
    }

    public int hashCode() {
        return Objects.hash(this.changing, this.sensitive, this.actualName, this.allValues());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeaderValueBase)) {
            return false;
        }
        HeaderValueBase that = (HeaderValueBase)o;
        return this.changing == that.changing && this.sensitive == that.sensitive && this.actualName.equals(that.actualName) && this.valueCount() == that.valueCount() && this.allValues().equals(that.allValues());
    }

    public String toString() {
        return "HttpHeaderImpl[name=" + String.valueOf(this.name) + ", values=" + String.valueOf(this.allValues()) + ", changing=" + this.changing + ", sensitive=" + this.sensitive + "]";
    }
}

