/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.ClientResponseHeaders;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpMediaType;
import io.helidon.common.http.ServerResponseHeadersImpl;
import io.helidon.common.http.SetCookie;
import io.helidon.common.http.WritableHeaders;
import io.helidon.common.media.type.MediaType;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public interface ServerResponseHeaders
extends ClientResponseHeaders,
WritableHeaders<ServerResponseHeaders> {
    public static ServerResponseHeaders create() {
        return new ServerResponseHeadersImpl();
    }

    public static ServerResponseHeaders create(Headers existing) {
        return new ServerResponseHeadersImpl(existing);
    }

    default public ServerResponseHeaders addAcceptPatches(HttpMediaType ... acceptableMediaTypes) {
        String[] values = new String[acceptableMediaTypes.length];
        for (int i = 0; i < acceptableMediaTypes.length; ++i) {
            HttpMediaType acceptableMediaType = acceptableMediaTypes[i];
            values[i] = acceptableMediaType.text();
        }
        return (ServerResponseHeaders)this.add(Http.Header.create(Http.Header.ACCEPT_PATCH, values));
    }

    default public ServerResponseHeaders addAcceptPatches(MediaType ... acceptableMediaTypes) {
        String[] values = new String[acceptableMediaTypes.length];
        for (int i = 0; i < acceptableMediaTypes.length; ++i) {
            MediaType acceptableMediaType = acceptableMediaTypes[i];
            values[i] = acceptableMediaType.text();
        }
        return (ServerResponseHeaders)this.add(Http.Header.create(Http.Header.ACCEPT_PATCH, values));
    }

    public ServerResponseHeaders addCookie(SetCookie var1);

    default public ServerResponseHeaders addCookie(String name, String value, Duration maxAge) {
        return this.addCookie(SetCookie.builder(name, value).maxAge(maxAge).build());
    }

    default public ServerResponseHeaders addCookie(String name, String value) {
        return this.addCookie(SetCookie.create(name, value));
    }

    public ServerResponseHeaders clearCookie(String var1);

    default public ServerResponseHeaders lastModified(Instant modified) {
        ZonedDateTime dt = ZonedDateTime.ofInstant(modified, ZoneId.systemDefault());
        return (ServerResponseHeaders)this.set(Http.Header.create(Http.Header.LAST_MODIFIED, true, false, dt.format(Http.DateTime.RFC_1123_DATE_TIME)));
    }

    default public ServerResponseHeaders lastModified(ZonedDateTime modified) {
        return (ServerResponseHeaders)this.set(Http.Header.create(Http.Header.LAST_MODIFIED, true, false, modified.format(Http.DateTime.RFC_1123_DATE_TIME)));
    }

    default public ServerResponseHeaders location(URI location) {
        return (ServerResponseHeaders)this.set(Http.Header.create(Http.Header.LOCATION, true, false, location.toASCIIString()));
    }

    default public ServerResponseHeaders expires(ZonedDateTime dateTime) {
        return (ServerResponseHeaders)this.set(Http.Header.create(Http.Header.EXPIRES, dateTime.format(Http.DateTime.RFC_1123_DATE_TIME)));
    }

    default public ServerResponseHeaders expires(Instant dateTime) {
        return (ServerResponseHeaders)this.set(Http.Header.create(Http.Header.EXPIRES, ZonedDateTime.ofInstant(dateTime, ZoneId.systemDefault()).format(Http.DateTime.RFC_1123_DATE_TIME)));
    }
}

