/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.LazyString;
import io.helidon.common.http.HeaderEnum;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpToken;
import io.helidon.common.http.WritableHeaders;
import java.nio.charset.StandardCharsets;

public final class Http1HeadersParser {
    private static final byte[] HD_HOST = (HeaderEnum.HOST.defaultCase() + ": ").getBytes(StandardCharsets.UTF_8);
    private static final byte[] HD_ACCEPT = (HeaderEnum.ACCEPT.defaultCase() + ": ").getBytes(StandardCharsets.UTF_8);
    private static final byte[] HD_CONNECTION = (HeaderEnum.CONNECTION.defaultCase() + ": ").getBytes(StandardCharsets.UTF_8);

    private Http1HeadersParser() {
    }

    public static WritableHeaders<?> readHeaders(DataReader reader, int maxHeadersSize, boolean validate) {
        int eol;
        WritableHeaders<?> headers = WritableHeaders.create();
        int maxLength = maxHeadersSize;
        do {
            Http.HeaderName header;
            if (reader.startsWithNewLine()) {
                reader.skip(2);
                return headers;
            }
            if ((eol = reader.findNewLine(maxLength -= (header = Http1HeadersParser.readHeaderName(reader, headers, maxLength, validate)).defaultCase().length() + 2)) == maxLength) {
                throw new IllegalStateException("Header size exceeded");
            }
            LazyString value = reader.readLazyString(StandardCharsets.US_ASCII, eol);
            reader.skip(2);
            headers.add(Http.Header.create(header, value));
        } while ((maxLength -= eol + 1) >= 0);
        throw new IllegalStateException("Header size exceeded");
    }

    private static Http.HeaderName readHeaderName(DataReader reader, WritableHeaders<?> headers, int maxLength, boolean validate) {
        switch (reader.lookup()) {
            case 72: {
                if (!reader.startsWith(HD_HOST)) break;
                reader.skip(HD_HOST.length);
                return HeaderEnum.HOST;
            }
            case 65: {
                if (!reader.startsWith(HD_ACCEPT)) break;
                reader.skip(HD_ACCEPT.length);
                return HeaderEnum.ACCEPT;
            }
            case 67: {
                if (!reader.startsWith(HD_CONNECTION)) break;
                reader.skip(HD_CONNECTION.length);
                return HeaderEnum.CONNECTION;
            }
        }
        int col = reader.findOrNewLine((byte)58, maxLength);
        if (col == maxLength) {
            throw new IllegalStateException("Header size exceeded");
        }
        if (col < 0) {
            throw new IllegalArgumentException("Invalid header, missing colon: " + reader.debugDataHex());
        }
        String headerName = reader.readAsciiString(col);
        if (validate) {
            HttpToken.validate(headerName);
        }
        Http.HeaderName header = Http.Header.create(headerName);
        reader.skip(1);
        if (32 != reader.read()) {
            throw new IllegalArgumentException("Invalid header, space not after colon: " + reader.debugDataHex());
        }
        return header;
    }
}

