/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.Builder;
import io.helidon.common.http.DirectHandlerDefault;
import io.helidon.common.http.DirectHandlerEmptyRequest;
import io.helidon.common.http.Http;
import io.helidon.common.http.ServerRequestHeaders;
import io.helidon.common.http.ServerResponseHeaders;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@FunctionalInterface
public interface DirectHandler {
    public static DirectHandler defaultHandler() {
        return DirectHandlerDefault.INSTANCE;
    }

    default public TransportResponse handle(TransportRequest request, EventType eventType, Http.Status defaultStatus, ServerResponseHeaders responseHeaders, Throwable thrown) {
        return this.handle(request, eventType, defaultStatus, responseHeaders, thrown.getMessage());
    }

    public TransportResponse handle(TransportRequest var1, EventType var2, Http.Status var3, ServerResponseHeaders var4, String var5);

    public static interface TransportRequest {
        public static TransportRequest empty() {
            return DirectHandlerEmptyRequest.INSTANCE;
        }

        public String protocolVersion();

        public String method();

        public String path();

        public ServerRequestHeaders headers();
    }

    public static enum EventType {
        BAD_REQUEST(Http.Status.BAD_REQUEST_400, false),
        PAYLOAD_TOO_LARGE(Http.Status.REQUEST_ENTITY_TOO_LARGE_413, false),
        FORBIDDEN(Http.Status.FORBIDDEN_403, true),
        INTERNAL_ERROR(Http.Status.INTERNAL_SERVER_ERROR_500, true),
        OTHER(Http.Status.INTERNAL_SERVER_ERROR_500, true);

        private final Http.Status defaultStatus;
        private final boolean keepAlive;

        private EventType(Http.Status defaultStatus, boolean keepAlive) {
            this.defaultStatus = defaultStatus;
            this.keepAlive = keepAlive;
        }

        public Http.Status defaultStatus() {
            return this.defaultStatus;
        }

        public boolean keepAlive() {
            return this.keepAlive;
        }
    }

    public static class TransportResponse {
        private final Http.Status status;
        private final ServerResponseHeaders headers;
        private final byte[] entity;
        private final boolean keepAlive;

        private TransportResponse(Builder builder) {
            this.status = builder.status;
            this.headers = builder.headers;
            this.entity = builder.entity;
            this.keepAlive = builder.keepAlive;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Http.Status status() {
            return this.status;
        }

        public ServerResponseHeaders headers() {
            return this.headers;
        }

        public Optional<byte[]> entity() {
            return Optional.ofNullable(this.entity);
        }

        public boolean keepAlive() {
            return this.keepAlive;
        }

        public static class Builder
        implements io.helidon.common.Builder<Builder, TransportResponse> {
            private Http.Status status = Http.Status.BAD_REQUEST_400;
            private byte[] entity;
            private ServerResponseHeaders headers = ServerResponseHeaders.create();
            private boolean keepAlive = true;

            private Builder() {
            }

            public TransportResponse build() {
                return new TransportResponse(this);
            }

            public Builder status(Http.Status status) {
                this.status = status;
                return this;
            }

            public Builder headers(ServerResponseHeaders headers) {
                this.headers = headers;
                return this;
            }

            public Builder header(Http.HeaderName name, String ... values) {
                this.headers.set(name, List.of(values));
                return this;
            }

            public Builder header(Http.HeaderValue header) {
                this.headers.add(header);
                return this;
            }

            public Builder keepAlive(boolean keepAlive) {
                this.keepAlive = keepAlive;
                return this;
            }

            public Builder entity(String entity) {
                this.headers.setIfAbsent(Http.HeaderValues.CONTENT_TYPE_TEXT_PLAIN);
                return this.entity(entity.getBytes(StandardCharsets.UTF_8));
            }

            public Builder entity(byte[] entity) {
                this.entity = Arrays.copyOf(entity, entity.length);
                if (this.entity.length == 0) {
                    this.headers.remove(Http.Header.CONTENT_LENGTH);
                } else {
                    this.header(Http.Header.CONTENT_LENGTH, String.valueOf(entity.length));
                }
                return this;
            }
        }
    }
}

