/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public record UriInfo(String scheme, String host, int port, String path, Optional<String> query) {
    public URI toUri() {
        try {
            return new URI(this.scheme, this.authority(), this.path, this.query.orElse(null), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("UriInfo cannot be used to create a URI: " + this, e);
        }
    }

    public String authority() {
        return this.host + ":" + this.port;
    }
}

