/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.HashParameters;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Parameters;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class HashHeaders
extends HashParameters
implements Headers {
    protected HashHeaders() {
    }

    protected HashHeaders(Map<String, List<String>> initialContent) {
        super(initialContent == null ? Collections.emptySet() : initialContent.entrySet());
    }

    protected HashHeaders(Iterable<Map.Entry<String, List<String>>> initialContent) {
        super(initialContent);
    }

    public static HashHeaders create() {
        return new HashHeaders();
    }

    public static HashHeaders create(Map<String, List<String>> initialContent) {
        return new HashHeaders(initialContent);
    }

    public static HashHeaders create(Parameters initialContent) {
        return new HashHeaders((Iterable<Map.Entry<String, List<String>>>)initialContent);
    }

    public static HashHeaders concat(Parameters ... parameters) {
        return HashHeaders.concat(new HashParameters.ArrayIterable<Parameters>(parameters));
    }

    public static HashHeaders concat(Iterable<Parameters> initialContent) {
        return HashHeaders.concat(initialContent, HashHeaders::new, HashHeaders::new);
    }

    @Override
    protected Map<String, List<String>> emptyMapForReads() {
        return new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    protected ConcurrentMap<String, List<String>> emptyMapForUpdates() {
        return new ConcurrentSkipListMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    }
}

